/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.java15;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ListIterator;
import org.apache.tools.ant.BuildException;

public class ProxyDiagnostics {
    private String destination;
    private URI destURI;
    public static final String DEFAULT_DESTINATION = "http://ant.apache.org/";

    public ProxyDiagnostics(String destination) {
        this.destination = destination;
        try {
            this.destURI = new URI(destination);
        }
        catch (URISyntaxException e) {
            throw new BuildException(e);
        }
    }

    public ProxyDiagnostics() {
        this(DEFAULT_DESTINATION);
    }

    public String toString() {
        ProxySelector selector = ProxySelector.getDefault();
        List<Proxy> list = selector.select(this.destURI);
        StringBuffer result2 = new StringBuffer();
        ListIterator<Proxy> proxies = list.listIterator();
        while (proxies.hasNext()) {
            Proxy proxy = (Proxy)proxies.next();
            SocketAddress address = proxy.address();
            if (address == null) {
                result2.append("Direct connection\n");
                continue;
            }
            result2.append(proxy.toString());
            if (address instanceof InetSocketAddress) {
                InetSocketAddress ina = (InetSocketAddress)address;
                result2.append(' ');
                result2.append(ina.getHostName());
                result2.append(':');
                result2.append(ina.getPort());
                if (ina.isUnresolved()) {
                    result2.append(" [unresolved]");
                } else {
                    InetAddress addr = ina.getAddress();
                    result2.append(" [");
                    result2.append(addr.getHostAddress());
                    result2.append(']');
                }
            }
            result2.append('\n');
        }
        return result2.toString();
    }
}

