/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gelitext;

import java.util.Arrays;
import org.broad.tribble.Feature;
import org.broad.tribble.gelitext.DiploidGenotype;

public class GeliTextFeature
implements Feature {
    private final String contig;
    private final long position;
    private final char refBase;
    private final int depthOfCoverage;
    private final int maximumMappingQual;
    private final DiploidGenotype genotype;
    private final double LODBestToReference;
    private final double LODBestToNext;
    private final double[] likelihoods;
    private static double Epsilon = 1.0E-4;

    public GeliTextFeature(String string2, long l, char c, int n, int n2, DiploidGenotype diploidGenotype, double d, double d2, double[] dArray) {
        this.contig = string2;
        this.position = l;
        this.refBase = c;
        this.depthOfCoverage = n;
        this.maximumMappingQual = n2;
        this.genotype = diploidGenotype;
        this.LODBestToReference = d;
        this.LODBestToNext = d2;
        this.likelihoods = dArray;
    }

    @Override
    public String getChr() {
        return this.contig;
    }

    @Override
    public int getStart() {
        return (int)this.position;
    }

    @Override
    public int getEnd() {
        return (int)this.position;
    }

    public char getRefBase() {
        return this.refBase;
    }

    public int getDepthOfCoverage() {
        return this.depthOfCoverage;
    }

    public int getMaximumMappingQual() {
        return this.maximumMappingQual;
    }

    public DiploidGenotype getGenotype() {
        return this.genotype;
    }

    public double getLODBestToNext() {
        return this.LODBestToNext;
    }

    public double getLODBestToReference() {
        return this.LODBestToReference;
    }

    public double[] getLikelihoods() {
        return this.likelihoods;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeliTextFeature)) {
            return false;
        }
        GeliTextFeature geliTextFeature = (GeliTextFeature)object;
        if (!Arrays.equals(this.likelihoods, geliTextFeature.likelihoods)) {
            return false;
        }
        if (!this.contig.equals(geliTextFeature.contig)) {
            return false;
        }
        if (this.position != geliTextFeature.position) {
            return false;
        }
        if (this.refBase != geliTextFeature.refBase) {
            return false;
        }
        if (this.depthOfCoverage != geliTextFeature.depthOfCoverage) {
            return false;
        }
        if (this.maximumMappingQual != geliTextFeature.maximumMappingQual) {
            return false;
        }
        if (this.genotype != geliTextFeature.genotype) {
            return false;
        }
        if (!(Math.abs(this.LODBestToReference - geliTextFeature.LODBestToReference) < Epsilon)) {
            return false;
        }
        return Math.abs(this.LODBestToNext - geliTextFeature.LODBestToNext) < Epsilon;
    }
}

