/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.broadinstitute.rnai.poolq.api.BarcodeProcessor;
import org.broadinstitute.rnai.poolq.impl.data.BarcodeVariants;
import org.broadinstitute.rnai.poolq.impl.data.ConstructReferenceDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryConstructReferenceDatabase
implements ConstructReferenceDatabase {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BarcodeProcessor barcodeProcessor;
    private final TMap<String, List<String>> reference = new THashMap<String, List<String>>();

    public InMemoryConstructReferenceDatabase(BarcodeProcessor barcodeProcessor) {
        this.barcodeProcessor = barcodeProcessor;
    }

    @Override
    public void buildConstructVariantDatabase(Set<String> set, boolean bl) {
        this.logger.info("Building construct barcode variant database");
        for (String string2 : set) {
            String string3 = this.barcodeProcessor.truncateConstructBarcode(string2);
            this.addVariantForBarcode(string2, string3);
            if (!bl) continue;
            Set<String> set2 = BarcodeVariants.buildVariants(string3);
            for (String string4 : set2) {
                this.addVariantForBarcode(string2, string4);
            }
        }
    }

    private void addVariantForBarcode(String string2, String string3) {
        ArrayList<String> arrayList = (ArrayList<String>)this.reference.get(string3);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.reference.put(string3, arrayList);
        }
        arrayList.add(string2);
    }

    @Override
    public List<String> getConstructBarcodesForVariant(String string2) {
        List list = (List)this.reference.get(string2);
        if (list == null) {
            return Collections.emptyList();
        }
        if (list.contains(string2)) {
            return Collections.singletonList(string2);
        }
        return list;
    }

    @Override
    public void close() throws IOException {
    }
}

