/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.broadinstitute.rnai.poolq.api.BarcodeProcessor;
import org.broadinstitute.rnai.poolq.api.BarcodeScore;
import org.broadinstitute.rnai.poolq.api.PoolQDataInputs;
import org.broadinstitute.rnai.poolq.api.PoolQDataOutputs;
import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.api.QualityReportData;
import org.broadinstitute.rnai.poolq.api.ReadTooShortException;
import org.broadinstitute.rnai.poolq.api.UnexpectedSequenceReportData;
import org.broadinstitute.rnai.poolq.impl.EventTracker;
import org.broadinstitute.rnai.poolq.impl.QualityReportDataImpl;
import org.broadinstitute.rnai.poolq.impl.SeqUtils;
import org.broadinstitute.rnai.poolq.impl.data.ConstructReferenceDatabase;
import org.broadinstitute.rnai.poolq.impl.data.CoocurrenceDatabase;
import org.broadinstitute.rnai.poolq.impl.data.CoocurrenceTempDatabase;
import org.broadinstitute.rnai.poolq.impl.data.InMemoryConstructReferenceDatabase;
import org.broadinstitute.rnai.poolq.impl.data.InMemoryCoocurrenceDatabase;
import org.broadinstitute.rnai.poolq.impl.reads.Read;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolQDataImpl
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(PoolQDataImpl.class);
    private static final int NUM_READS_PER_PROGRESS_REPORT = 1000000;
    private static final int TOO_MANY_NS = 2;
    private final BarcodeProcessor barcodeProcessor;
    private final PoolQDataInputs poolQDataInputs;
    private final EventTracker eventTracker;
    private List<String> conditions;
    private final CoocurrenceDatabase readCountDatabase;
    private final CoocurrenceDatabase unexpectedReadCountDatabase;
    private final TObjectIntMap<String> barcodeToReadCountMap;
    private final TObjectIntMap<String> unexpectedConstructUnknownBarcodeReadCount;
    private final TObjectIntMap<String> barcodeToMatchingConstructReadCountMap;

    public PoolQDataImpl(PoolQDataInputs poolQDataInputs, EventTracker eventTracker) {
        this.poolQDataInputs = poolQDataInputs;
        this.eventTracker = eventTracker;
        this.barcodeProcessor = poolQDataInputs.getBarcodeProcessor();
        this.conditions = new ArrayList<String>(new LinkedHashSet<String>(poolQDataInputs.getSampleBarcodeToConditionMap().values()));
        this.readCountDatabase = new InMemoryCoocurrenceDatabase(new ArrayList<String>(poolQDataInputs.getSampleBarcodeToConditionMap().keySet()));
        this.unexpectedReadCountDatabase = poolQDataInputs.countUnexpectedSequences() ? new CoocurrenceTempDatabase() : null;
        this.barcodeToReadCountMap = new TObjectIntHashMap<String>();
        this.barcodeToMatchingConstructReadCountMap = new TObjectIntHashMap<String>();
        this.unexpectedConstructUnknownBarcodeReadCount = new TObjectIntHashMap<String>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PoolQDataOutputs runPoolQ() throws PoolQException {
        try (InMemoryConstructReferenceDatabase inMemoryConstructReferenceDatabase = new InMemoryConstructReferenceDatabase(this.barcodeProcessor);){
            long l;
            inMemoryConstructReferenceDatabase.buildConstructVariantDatabase(this.poolQDataInputs.getConstructBarcodeToConstructIdsMap().keySet(), !this.poolQDataInputs.requireExactMatch());
            long l2 = l = System.currentTimeMillis();
            for (Read read : this.poolQDataInputs.getReadsIterable()) {
                String string2;
                String string3;
                l2 = this.logProgressUpdate(l, l2);
                try {
                    string3 = read.getSampleBarcode();
                    string2 = read.getConstructBarcode();
                }
                catch (ReadTooShortException readTooShortException) {
                    if (!this.poolQDataInputs.skipShortReads()) throw readTooShortException;
                    this.eventTracker.skippedShortRead();
                    continue;
                }
                if (string3.contains("N")) {
                    this.eventTracker.sampleBarcodeHasN();
                    continue;
                }
                this.eventTracker.processedRead();
                if (string2 == null) continue;
                this.incrementCountForSampleBarcode(this.barcodeToReadCountMap, string3);
                this.incrementScoreForConstructVariant(inMemoryConstructReferenceDatabase, string3, string2);
            }
            logger.debug("Finished processing reads");
            PoolQDataOutputs poolQDataOutputs = this.getPoolQDataOutputs();
            return poolQDataOutputs;
        }
        catch (IOException iOException) {
            logger.error("Caught unexpected IO exception while running PoolQ", iOException);
            throw new PoolQException("Error running PoolQ", iOException);
        }
    }

    private long logProgressUpdate(long l, long l2) {
        long l3 = this.eventTracker.readsProcessed();
        if (l3 > 0L && l3 % 1000000L == 0L) {
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l2;
            long l6 = l4 - l;
            double d = l3;
            double d2 = (double)l5 > 0.0 ? (double)(1000000L / l5) : 0.0;
            double d3 = (double)l6 > 0.0 ? d / (double)l6 : 0.0;
            logger.info("Processed {} reads -- rate [reads/ms]: {} (inst) {} (avg)", l3, d2, d3);
            return System.currentTimeMillis();
        }
        return l2;
    }

    @Override
    public void close() {
        try {
            if (this.unexpectedReadCountDatabase != null) {
                this.unexpectedReadCountDatabase.close();
            }
        }
        catch (IOException iOException) {
            throw new PoolQException("Error closing PoolQ data", iOException);
        }
    }

    private void incrementScoreForConstructVariant(ConstructReferenceDatabase constructReferenceDatabase, String string2, String string3) {
        String string4 = this.poolQDataInputs.getSampleBarcodeToConditionMap().get(string2);
        List<String> list = constructReferenceDatabase.getConstructBarcodesForVariant(string3);
        if (list.size() == 1 || list.size() > 1 && this.poolQDataInputs.scoreAmbiguousMatches()) {
            if (!this.poolQDataInputs.onlyReportUnexpectedSequences()) {
                this.eventTracker.readMatchedConstructBarcode();
                for (String string5 : list) {
                    String string6 = this.barcodeProcessor.truncateConstructBarcode(string5);
                    if (!string6.equals(string3)) {
                        this.eventTracker.readMatchedConstructBarcodeWithMismatch();
                    }
                    if (string4 == null) continue;
                    this.barcodeToMatchingConstructReadCountMap.adjustOrPutValue(string2, 1, 1);
                    this.readCountDatabase.increment(string5, string2);
                }
            }
        } else if (this.poolQDataInputs.countUnexpectedSequences() && SeqUtils.hasFewerThanKNs(string3, 2)) {
            this.handleUnexpectedConstructBarcode(string3, string2, string4);
        }
    }

    private void handleUnexpectedConstructBarcode(String string2, String string3, String string4) {
        if (string4 != null) {
            this.countUnexpectedConstructAndBarcode(string2, string3);
        } else {
            this.unexpectedConstructUnknownBarcodeReadCount.adjustOrPutValue(string3, 1, 1);
        }
    }

    private void incrementCountForSampleBarcode(TObjectIntMap<String> tObjectIntMap, String string2) {
        if (!this.poolQDataInputs.onlyReportUnexpectedSequences()) {
            tObjectIntMap.adjustOrPutValue(string2, 1, 1);
        }
    }

    private Map<String, List<String>> buildTruncatedConstructBarcodeToConstructIdsMap(Map<String, List<String>> map2) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
            String string2 = entry.getKey();
            List<String> list = entry.getValue();
            String string3 = this.barcodeProcessor.truncateConstructBarcode(string2);
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string3);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string3, arrayList);
            }
            arrayList.addAll(list);
        }
        return hashMap;
    }

    private void countUnexpectedConstructAndBarcode(String string2, String string3) {
        this.unexpectedReadCountDatabase.increment(string2, string3);
    }

    private PoolQDataOutputs getPoolQDataOutputs() {
        final Map<String, SortedSet<String>> map2 = PoolQDataImpl.invertMap(this.poolQDataInputs.getSampleBarcodeToConditionMap(), new HashMap(), new CollectionFactory<String, SortedSet<String>>(){

            @Override
            public SortedSet<String> newCollection() {
                return new TreeSet<String>();
            }
        });
        final TObjectIntMap<String> tObjectIntMap = this.buildConditionToMatchingConstructReadCountMap();
        return new PoolQDataOutputs(){

            @Override
            public PoolQScores getPoolQScores() {
                return new PoolQScores(){

                    @Override
                    public Collection<String> getConstructBarcodes() {
                        return PoolQDataImpl.this.poolQDataInputs.getConstructBarcodeToConstructIdsMap().keySet();
                    }

                    @Override
                    public Collection<String> getIdsForConstructBarcode(String string2) {
                        return PoolQDataImpl.this.poolQDataInputs.getConstructBarcodeToConstructIdsMap().get(string2);
                    }

                    @Override
                    public Map<String, SortedSet<String>> getConditionToBarcodeMap() {
                        return map2;
                    }

                    @Override
                    public List<String> getConditions() {
                        return PoolQDataImpl.this.conditions;
                    }

                    @Override
                    public Map<String, Integer> getScoresBySampleForConstruct(String string2) {
                        return PoolQDataImpl.this.readCountDatabase.getScoresBySampleForConstruct(string2);
                    }

                    @Override
                    public Integer getMatchingConstructReadCountForCondition(String string2) {
                        return tObjectIntMap.get(string2);
                    }
                };
            }

            @Override
            public QualityReportData getQualityReportData() {
                Map map22 = PoolQDataImpl.this.buildTruncatedConstructBarcodeToConstructIdsMap(PoolQDataImpl.this.poolQDataInputs.getConstructBarcodeToConstructIdsMap());
                return new QualityReportDataImpl(PoolQDataImpl.this.poolQDataInputs.getSampleBarcodeLength(), PoolQDataImpl.this.poolQDataInputs.getSampleBarcodeToConditionMap(), PoolQDataImpl.this.barcodeToReadCountMap, PoolQDataImpl.this.barcodeToMatchingConstructReadCountMap, PoolQDataImpl.this.getTruncatedConstructToCollidingConstructIdsMap(map22), PoolQDataImpl.this.eventTracker.readsProcessed(), PoolQDataImpl.this.eventTracker.readsWithMatchingConstructBarcode(), PoolQDataImpl.this.eventTracker.readsWithMatchingConstructBarcodeWithMismatch(), PoolQDataImpl.this.eventTracker.skippedShortReads(), PoolQDataImpl.this.poolQDataInputs.findConstructBarcodesByPrefix(), PoolQDataImpl.this.eventTracker.readsWithNoBarcodeSearchPrefix(), PoolQDataImpl.this.eventTracker.maxConstructBarcodeIndex(), PoolQDataImpl.this.eventTracker.minConstructBarcodeIndex(), PoolQDataImpl.this.eventTracker.meanConstructBarcodeIndex());
            }

            @Override
            public UnexpectedSequenceReportData getUnexpectedSequenceReportData() {
                final Map map22 = PoolQDataImpl.this.buildTruncatedConstructBarcodeToConstructIdsMap(PoolQDataImpl.this.poolQDataInputs.getPlatformConstructBarcodeToConstructIdsMap());
                return new UnexpectedSequenceReportData(){

                    @Override
                    public long getNumberOfReads() {
                        return PoolQDataImpl.this.eventTracker.readsProcessed();
                    }

                    @Override
                    public Iterable<String> getBarcodesMappedToConditions() {
                        return PoolQDataImpl.this.poolQDataInputs.getSampleBarcodeToConditionMap().keySet();
                    }

                    @Override
                    public Iterable<BarcodeScore> getUnexpectedConstructBarcodes() {
                        return PoolQDataImpl.this.unexpectedReadCountDatabase;
                    }

                    @Override
                    public Collection<String> getPlatformConstructIdsForConstructBarcode(String string2) {
                        Collection collection = (Collection)map22.get(string2);
                        if (collection == null) {
                            return Collections.emptyList();
                        }
                        return collection;
                    }

                    @Override
                    public Collection<String> getUnexpectedSampleBarcodes() {
                        return PoolQDataImpl.this.unexpectedConstructUnknownBarcodeReadCount.keySet();
                    }

                    @Override
                    public Integer getUnexpectedSequenceReadCountForBarcode(String string2) {
                        if (PoolQDataImpl.this.poolQDataInputs.getSampleBarcodeToConditionMap().containsKey(string2)) {
                            return null;
                        }
                        Integer n = PoolQDataImpl.this.unexpectedConstructUnknownBarcodeReadCount.get(string2);
                        if (n == null) {
                            return 0;
                        }
                        return n;
                    }
                };
            }
        };
    }

    private TObjectIntMap<String> buildConditionToMatchingConstructReadCountMap() {
        final TObjectIntHashMap<String> tObjectIntHashMap = new TObjectIntHashMap<String>();
        this.barcodeToMatchingConstructReadCountMap.forEachEntry(new TObjectIntProcedure<String>(){

            @Override
            public boolean execute(String string2, int n) {
                String string3 = PoolQDataImpl.this.poolQDataInputs.getSampleBarcodeToConditionMap().get(string2);
                tObjectIntHashMap.adjustOrPutValue(string3, n, n);
                return true;
            }
        });
        return tObjectIntHashMap;
    }

    private Map<String, Set<String>> getTruncatedConstructToCollidingConstructIdsMap(Map<String, List<String>> map2) {
        LinkedHashMap<String, Set<String>> linkedHashMap = new LinkedHashMap<String, Set<String>>();
        for (String string2 : map2.keySet()) {
            List<String> list = map2.get(string2);
            if (list.size() <= 1) continue;
            linkedHashMap.put(string2, new LinkedHashSet<String>(list));
        }
        return linkedHashMap;
    }

    static <K, V, C extends Collection<K>> Map<V, C> invertMap(Map<K, V> map2, Map<V, C> map3, CollectionFactory<K, C> collectionFactory) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            V v = entry.getValue();
            Collection<Object> collection = (Collection)map3.get(v);
            if (collection == null) {
                collection = collectionFactory.newCollection();
                map3.put((Collection)v, (C)collection);
            }
            collection.add(entry.getKey());
        }
        return map3;
    }

    static interface CollectionFactory<E, C extends Collection<E>> {
        public C newCollection();
    }
}

