/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.NameAwareCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFConstants;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;
import org.broadinstitute.variant.vcf.VCFFilterHeaderLine;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;
import org.broadinstitute.variant.vcf.VCFSimpleHeaderLine;
import org.broadinstitute.variant.vcf.VCFStandardHeaderLines;

public abstract class AbstractVCFCodec
extends AsciiFeatureCodec<VariantContext>
implements NameAwareCodec {
    public static final int MAX_ALLELE_SIZE_BEFORE_WARNING = (int)Math.pow(2.0, 20.0);
    protected static final int NUM_STANDARD_FIELDS = 8;
    protected VCFHeader header = null;
    protected VCFHeaderVersion version = null;
    protected Map<String, List<Allele>> alleleMap = new HashMap<String, List<Allele>>(3);
    protected String[] GTValueArray = new String[100];
    protected String[] genotypeKeyArray = new String[100];
    protected String[] infoFieldArray = new String[1000];
    protected String[] infoValueArray = new String[1000];
    public static boolean validate = true;
    protected String[] parts = null;
    protected String[] genotypeParts = null;
    protected final String[] locParts = new String[6];
    protected HashMap<String, List<String>> filterHash = new HashMap();
    protected String name = "Unknown";
    protected int lineNo = 0;
    protected Map<String, String> stringCache = new HashMap<String, String>();
    protected boolean warnedAboutNoEqualsForNonFlag = false;
    protected boolean doOnTheFlyModifications = true;
    private static final String[] INT_DECODE_ARRAY = new String[10000];

    protected AbstractVCFCodec() {
        super(VariantContext.class);
    }

    protected abstract List<String> parseFilters(String var1);

    protected VCFHeader parseHeaderFromLines(List<String> list, VCFHeaderVersion vCFHeaderVersion) {
        this.version = vCFHeaderVersion;
        LinkedHashSet<VCFHeaderLine> linkedHashSet = new LinkedHashSet<VCFHeaderLine>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        int n = 0;
        for (String string2 : list) {
            if (!string2.startsWith("##")) {
                String[] stringArray = string2.substring(1).split("\t");
                if (stringArray.length < VCFHeader.HEADER_FIELDS.values().length) {
                    throw new TribbleException.InvalidHeader("there are not enough columns present in the header line: " + string2);
                }
                int n2 = 0;
                for (VCFHeader.HEADER_FIELDS hEADER_FIELDS : VCFHeader.HEADER_FIELDS.values()) {
                    try {
                        if (hEADER_FIELDS != VCFHeader.HEADER_FIELDS.valueOf(stringArray[n2])) {
                            throw new TribbleException.InvalidHeader("we were expecting column name '" + (Object)((Object)hEADER_FIELDS) + "' but we saw '" + stringArray[n2] + "'");
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new TribbleException.InvalidHeader("unknown column name '" + stringArray[n2] + "'; it does not match a legal column header name.");
                    }
                    ++n2;
                }
                boolean bl = false;
                if (n2 < stringArray.length) {
                    if (!stringArray[n2].equals("FORMAT")) {
                        throw new TribbleException.InvalidHeader("we were expecting column name 'FORMAT' but we saw '" + stringArray[n2] + "'");
                    }
                    bl = true;
                    ++n2;
                }
                while (n2 < stringArray.length) {
                    linkedHashSet2.add(stringArray[n2++]);
                }
                if (!bl || linkedHashSet2.size() != 0) continue;
                throw new TribbleException.InvalidHeader("The FORMAT field was provided but there is no genotype/sample data");
            }
            if (string2.startsWith("##INFO")) {
                VCFInfoHeaderLine vCFInfoHeaderLine = new VCFInfoHeaderLine(string2.substring(7), vCFHeaderVersion);
                linkedHashSet.add(vCFInfoHeaderLine);
                continue;
            }
            if (string2.startsWith("##FILTER")) {
                VCFFilterHeaderLine vCFFilterHeaderLine = new VCFFilterHeaderLine(string2.substring(9), vCFHeaderVersion);
                linkedHashSet.add(vCFFilterHeaderLine);
                continue;
            }
            if (string2.startsWith("##FORMAT")) {
                VCFFormatHeaderLine vCFFormatHeaderLine = new VCFFormatHeaderLine(string2.substring(9), vCFHeaderVersion);
                linkedHashSet.add(vCFFormatHeaderLine);
                continue;
            }
            if (string2.startsWith("##contig")) {
                VCFContigHeaderLine vCFContigHeaderLine = new VCFContigHeaderLine(string2.substring(9), vCFHeaderVersion, "##contig".substring(2), n++);
                linkedHashSet.add(vCFContigHeaderLine);
                continue;
            }
            if (string2.startsWith("##ALT")) {
                VCFSimpleHeaderLine vCFSimpleHeaderLine = new VCFSimpleHeaderLine(string2.substring(6), vCFHeaderVersion, "##ALT".substring(2), Arrays.asList("ID", "Description"));
                linkedHashSet.add(vCFSimpleHeaderLine);
                continue;
            }
            int n3 = string2.indexOf("=");
            if (n3 == -1) continue;
            linkedHashSet.add(new VCFHeaderLine(string2.substring(2, n3), string2.substring(n3 + 1)));
        }
        this.header = new VCFHeader(linkedHashSet, linkedHashSet2);
        if (this.doOnTheFlyModifications) {
            this.header = VCFStandardHeaderLines.repairStandardHeaderLines(this.header);
        }
        return this.header;
    }

    public VCFHeader setVCFHeader(VCFHeader vCFHeader, VCFHeaderVersion vCFHeaderVersion) {
        this.version = vCFHeaderVersion;
        this.header = this.doOnTheFlyModifications ? VCFStandardHeaderLines.repairStandardHeaderLines(vCFHeader) : vCFHeader;
        return this.header;
    }

    @Override
    public Feature decodeLoc(String string2) {
        return this.decodeLine(string2, false);
    }

    @Override
    public VariantContext decode(String string2) {
        return this.decodeLine(string2, true);
    }

    private VariantContext decodeLine(String string2, boolean bl) {
        if (string2.startsWith("#")) {
            return null;
        }
        if (this.header == null) {
            throw new TribbleException("VCF Header cannot be null when decoding a record");
        }
        if (this.parts == null) {
            this.parts = new String[Math.min(this.header.getColumnCount(), 9)];
        }
        int n = ParsingUtils.split(string2, this.parts, '\t', true);
        if ((this.header == null || !this.header.hasGenotypingData()) && n != 8 || this.header != null && this.header.hasGenotypingData() && n != 9) {
            throw new TribbleException("Line " + this.lineNo + ": there aren't enough columns for line " + string2 + " (we expected " + (this.header == null ? 8 : 9) + " tokens, and saw " + n + " )");
        }
        return this.parseVCFLine(this.parts, bl);
    }

    private VariantContext parseVCFLine(String[] stringArray, boolean bl) {
        Object object;
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder();
        variantContextBuilder.source(this.getName());
        ++this.lineNo;
        String string2 = this.getCachedString(stringArray[0]);
        variantContextBuilder.chr(string2);
        int n = -1;
        try {
            n = Integer.valueOf(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            this.generateException(stringArray[1] + " is not a valid start position in the VCF format");
        }
        variantContextBuilder.start(n);
        if (stringArray[2].length() == 0) {
            this.generateException("The VCF specification requires a valid ID field");
        } else if (stringArray[2].equals(".")) {
            variantContextBuilder.noID();
        } else {
            variantContextBuilder.id(stringArray[2]);
        }
        String string3 = this.getCachedString(stringArray[3].toUpperCase());
        String string4 = this.getCachedString(stringArray[4].toUpperCase());
        variantContextBuilder.log10PError(AbstractVCFCodec.parseQual(stringArray[5]));
        List<String> list = this.parseFilters(this.getCachedString(stringArray[6]));
        if (list != null) {
            variantContextBuilder.filters(new HashSet<String>(list));
        }
        Map<String, Object> map2 = this.parseInfo(stringArray[7]);
        variantContextBuilder.attributes(map2);
        if (map2.containsKey("END")) {
            try {
                variantContextBuilder.stop(Integer.valueOf(map2.get("END").toString()).intValue());
            }
            catch (Exception exception) {
                this.generateException("the END value in the INFO field is not valid");
            }
        } else {
            variantContextBuilder.stop(n + string3.length() - 1);
        }
        List<Allele> list2 = AbstractVCFCodec.parseAlleles(string3, string4, this.lineNo);
        variantContextBuilder.alleles((Collection<Allele>)list2);
        if (stringArray.length > 8 && bl) {
            object = new LazyVCFGenotypesParser(list2, string2, n);
            int n2 = this.header.getNGenotypeSamples();
            LazyGenotypesContext lazyGenotypesContext = new LazyGenotypesContext((LazyGenotypesContext.LazyParser)object, stringArray[8], n2);
            if (!this.header.samplesWereAlreadySorted()) {
                lazyGenotypesContext.decode();
            }
            variantContextBuilder.genotypesNoValidation(lazyGenotypesContext);
        }
        object = null;
        try {
            object = variantContextBuilder.make();
        }
        catch (Exception exception) {
            this.generateException(exception.getMessage());
        }
        return object;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string2) {
        this.name = string2;
    }

    protected String getCachedString(String string2) {
        String string3 = this.stringCache.get(string2);
        if (string3 == null) {
            string3 = new String(string2);
            this.stringCache.put(string3, string3);
        }
        return string3;
    }

    private Map<String, Object> parseInfo(String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string2.length() == 0) {
            this.generateException("The VCF specification requires a valid (non-zero length) info field");
        }
        if (!string2.equals(".")) {
            if (string2.indexOf("\t") != -1 || string2.indexOf(" ") != -1) {
                this.generateException("The VCF specification does not allow for whitespace in the INFO field. Offending field value was \"" + string2 + "\"");
            }
            int n = ParsingUtils.split(string2, this.infoFieldArray, ';', false);
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                String string3;
                int n2 = this.infoFieldArray[i].indexOf("=");
                if (n2 != -1) {
                    Object object3;
                    string3 = this.infoFieldArray[i].substring(0, n2);
                    object2 = this.infoFieldArray[i].substring(n2 + 1);
                    int n3 = ParsingUtils.split((String)object2, this.infoValueArray, ',', false);
                    if (n3 == 1) {
                        object = this.infoValueArray[0];
                        object3 = this.header.getInfoHeaderLine(string3);
                        if (object3 != null && ((VCFCompoundHeaderLine)object3).getType() == VCFHeaderLineType.Flag && object.equals("0")) {
                            continue;
                        }
                    } else {
                        object3 = new ArrayList(n3);
                        for (int j = 0; j < n3; ++j) {
                            ((ArrayList)object3).add(this.infoValueArray[j]);
                        }
                        object = object3;
                    }
                } else {
                    string3 = this.infoFieldArray[i];
                    object2 = this.header.getInfoHeaderLine(string3);
                    object = object2 != null && ((VCFCompoundHeaderLine)object2).getType() != VCFHeaderLineType.Flag ? "." : Boolean.valueOf(true);
                }
                if ("".equals(object)) {
                    object = ".";
                }
                hashMap.put(string3, object);
            }
        }
        return hashMap;
    }

    protected static Allele oneAllele(String string2, List<Allele> list) {
        int n;
        if (string2.equals(".")) {
            return Allele.NO_CALL;
        }
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TribbleException.InternalCodecException("The following invalid GT allele index was encountered in the file: " + string2);
        }
        if (n >= list.size()) {
            throw new TribbleException.InternalCodecException("The allele with index " + string2 + " is not defined in the REF/ALT columns in the record");
        }
        return list.get(n);
    }

    protected static List<Allele> parseGenotypeAlleles(String string2, List<Allele> list, Map<String, List<Allele>> map2) {
        List<Allele> list2 = map2.get(string2);
        if (list2 == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/|\\");
            list2 = new ArrayList<Allele>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                list2.add(AbstractVCFCodec.oneAllele(string3, list));
            }
            map2.put(string2, list2);
        }
        return list2;
    }

    protected static Double parseQual(String string2) {
        if (string2.equals(".")) {
            return 1.0;
        }
        Double d = Double.valueOf(string2);
        if (d < 0.0 && Math.abs(d - VCFConstants.MISSING_QUALITY_v3_DOUBLE) < VCFConstants.VCF_ENCODING_EPSILON) {
            return 1.0;
        }
        return d / -10.0;
    }

    protected static List<Allele> parseAlleles(String string2, String string3, int n) {
        ArrayList<Allele> arrayList = new ArrayList<Allele>(2);
        AbstractVCFCodec.checkAllele(string2, true, n);
        Allele allele = Allele.create(string2, true);
        arrayList.add(allele);
        if (string3.indexOf(",") == -1) {
            AbstractVCFCodec.parseSingleAltAllele(arrayList, string3, n);
        } else {
            for (String string4 : string3.split(",")) {
                AbstractVCFCodec.parseSingleAltAllele(arrayList, string4, n);
            }
        }
        return arrayList;
    }

    private static void checkAllele(String string2, boolean bl, int n) {
        if (string2 == null || string2.length() == 0) {
            AbstractVCFCodec.generateException("Empty alleles are not permitted in VCF records", n);
        }
        if (AbstractVCFCodec.isSymbolicAllele(string2)) {
            if (bl) {
                AbstractVCFCodec.generateException("Symbolic alleles not allowed as reference allele: " + string2, n);
            }
        } else {
            if (string2.charAt(0) == 'D' || string2.charAt(0) == 'I') {
                AbstractVCFCodec.generateException("Insertions/Deletions are not supported when reading 3.x VCF's. Please convert your file to VCF4 using VCFTools, available at http://vcftools.sourceforge.net/index.html", n);
            }
            if (!Allele.acceptableAlleleBases(string2)) {
                AbstractVCFCodec.generateException("Unparsable vcf record with allele " + string2, n);
            }
            if (bl && string2.equals(".")) {
                AbstractVCFCodec.generateException("The reference allele cannot be missing", n);
            }
        }
    }

    private static boolean isSymbolicAllele(String string2) {
        return string2 != null && string2.length() > 2 && (string2.startsWith("<") && string2.endsWith(">") || string2.contains("[") || string2.contains("]"));
    }

    private static void parseSingleAltAllele(List<Allele> list, String string2, int n) {
        AbstractVCFCodec.checkAllele(string2, false, n);
        Allele allele = Allele.create(string2, false);
        if (!allele.isNoCall()) {
            list.add(allele);
        }
    }

    public static final boolean canDecodeFile(String string2, String string3) {
        try {
            return AbstractVCFCodec.isVCFStream(new FileInputStream(string2), string3) || AbstractVCFCodec.isVCFStream(new GZIPInputStream(new FileInputStream(string2)), string3) || AbstractVCFCodec.isVCFStream(new BlockCompressedInputStream(new FileInputStream(string2)), string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isVCFStream(InputStream inputStream, String string2) {
        try {
            boolean bl;
            byte[] byArray = new byte[string2.length()];
            int n = inputStream.read(byArray, 0, string2.length());
            boolean bl2 = bl = Arrays.equals(byArray, string2.getBytes());
            return bl2;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException runtimeException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public LazyGenotypesContext.LazyData createGenotypeMap(String string2, List<Allele> list, String string3, int n) {
        int n2;
        if (this.genotypeParts == null) {
            this.genotypeParts = new String[this.header.getColumnCount() - 8];
        }
        if ((n2 = ParsingUtils.split(string2, this.genotypeParts, '\t')) != this.genotypeParts.length) {
            AbstractVCFCodec.generateException("there are " + (n2 - 1) + " genotypes while the header requires that " + (this.genotypeParts.length - 1) + " genotypes be present for all records at " + string3 + ":" + n, this.lineNo);
        }
        ArrayList<Genotype> arrayList = new ArrayList<Genotype>(n2);
        int n3 = ParsingUtils.split(this.genotypeParts[0], this.genotypeKeyArray, ':');
        Iterator<String> iterator2 = this.header.getGenotypeSamples().iterator();
        this.alleleMap.clear();
        for (int i = 1; i < n2; ++i) {
            int n4 = ParsingUtils.split(this.genotypeParts[i], this.GTValueArray, ':');
            String string4 = iterator2.next();
            GenotypeBuilder genotypeBuilder = new GenotypeBuilder(string4);
            if (n3 < n4) {
                this.generateException("There are too many keys for the sample " + string4 + ", keys = " + this.parts[8] + ", values = " + this.parts[i]);
            }
            int n5 = -1;
            if (n3 >= 1) {
                genotypeBuilder.maxAttributes(n3 - 1);
                for (int j = 0; j < n3; ++j) {
                    boolean bl;
                    String string5 = this.genotypeKeyArray[j];
                    boolean bl2 = bl = j >= n4;
                    if (string5.equals("GT")) {
                        n5 = j;
                        continue;
                    }
                    if (bl) continue;
                    if (string5.equals("FT")) {
                        List<String> list2 = this.parseFilters(this.getCachedString(this.GTValueArray[j]));
                        if (list2 == null) continue;
                        genotypeBuilder.filters(list2);
                        continue;
                    }
                    if (this.GTValueArray[j].equals(".")) continue;
                    if (string5.equals("GQ")) {
                        if (this.GTValueArray[j].equals("-1")) {
                            genotypeBuilder.noGQ();
                            continue;
                        }
                        genotypeBuilder.GQ((int)Math.round(Double.valueOf(this.GTValueArray[j])));
                        continue;
                    }
                    if (string5.equals("AD")) {
                        genotypeBuilder.AD(AbstractVCFCodec.decodeInts(this.GTValueArray[j]));
                        continue;
                    }
                    if (string5.equals("PL")) {
                        genotypeBuilder.PL(AbstractVCFCodec.decodeInts(this.GTValueArray[j]));
                        continue;
                    }
                    if (string5.equals("GL")) {
                        genotypeBuilder.PL(GenotypeLikelihoods.fromGLField(this.GTValueArray[j]).getAsPLs());
                        continue;
                    }
                    if (string5.equals("DP")) {
                        genotypeBuilder.DP(Integer.valueOf(this.GTValueArray[j]));
                        continue;
                    }
                    genotypeBuilder.attribute(string5, this.GTValueArray[j]);
                }
            }
            if (this.version != VCFHeaderVersion.VCF4_1 && n5 == -1) {
                this.generateException("Unable to find the GT field for the record; the GT field is required in VCF4.0");
            }
            if (n5 > 0) {
                this.generateException("Saw GT field at position " + n5 + ", but it must be at the first position for genotypes when present");
            }
            ArrayList<Allele> arrayList2 = n5 == -1 ? new ArrayList<Allele>(0) : AbstractVCFCodec.parseGenotypeAlleles(this.GTValueArray[n5], list, this.alleleMap);
            genotypeBuilder.alleles(arrayList2);
            genotypeBuilder.phased(n5 != -1 && this.GTValueArray[n5].indexOf("|") != -1);
            try {
                arrayList.add(genotypeBuilder.make());
                continue;
            }
            catch (TribbleException tribbleException) {
                throw new TribbleException.InternalCodecException(tribbleException.getMessage() + ", at position " + string3 + ":" + n);
            }
        }
        return new LazyGenotypesContext.LazyData(arrayList, this.header.getSampleNamesInOrder(), this.header.getSampleNameToOffset());
    }

    private static final int[] decodeInts(String string2) {
        int n = ParsingUtils.split(string2, INT_DECODE_ARRAY, ',');
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Integer.valueOf(INT_DECODE_ARRAY[i]);
        }
        return nArray;
    }

    public final void disableOnTheFlyModifications() {
        this.doOnTheFlyModifications = false;
    }

    protected void generateException(String string2) {
        throw new TribbleException(String.format("The provided VCF file is malformed at approximately line number %d: %s", this.lineNo, string2));
    }

    protected static void generateException(String string2, int n) {
        throw new TribbleException(String.format("The provided VCF file is malformed at approximately line number %d: %s", n, string2));
    }

    class LazyVCFGenotypesParser
    implements LazyGenotypesContext.LazyParser {
        final List<Allele> alleles;
        final String contig;
        final int start;

        LazyVCFGenotypesParser(List<Allele> list, String string2, int n) {
            this.alleles = list;
            this.contig = string2;
            this.start = n;
        }

        @Override
        public LazyGenotypesContext.LazyData parse(Object object) {
            return AbstractVCFCodec.this.createGenotypeMap((String)object, this.alleles, this.contig, this.start);
        }
    }
}

