/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.util.Map;
import org.broad.tribble.TribbleException;

public class VCFHeaderLine
implements Comparable {
    protected static final boolean ALLOW_UNBOUND_DESCRIPTIONS = true;
    protected static final String UNBOUND_DESCRIPTION = "Not provided in original VCF header";
    private String mKey = null;
    private String mValue = null;

    public VCFHeaderLine(String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("VCFHeaderLine: key cannot be null");
        }
        if (string2.contains("<") || string2.contains(">")) {
            throw new IllegalArgumentException("VCFHeaderLine: key cannot contain angle brackets");
        }
        if (string2.contains("=")) {
            throw new IllegalArgumentException("VCFHeaderLine: key cannot contain an equals sign");
        }
        this.mKey = string2;
        this.mValue = string3;
    }

    public String getKey() {
        return this.mKey;
    }

    public String getValue() {
        return this.mValue;
    }

    public boolean shouldBeAddedToDictionary() {
        return false;
    }

    public String toString() {
        return this.toStringEncoding();
    }

    protected String toStringEncoding() {
        return this.mKey + "=" + this.mValue;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VCFHeaderLine)) {
            return false;
        }
        return this.mKey.equals(((VCFHeaderLine)object).getKey()) && this.mValue.equals(((VCFHeaderLine)object).getValue());
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public static boolean isHeaderLine(String string2) {
        return string2 != null && string2.length() > 0 && "#".equals(string2.substring(0, 1));
    }

    public static String toStringEncoding(Map<String, ? extends Object> map2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        boolean bl = true;
        for (Map.Entry<String, ? extends Object> entry : map2.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            if (entry.getValue() == null) {
                throw new TribbleException.InternalCodecException("Header problem: unbound value at " + entry + " from " + map2);
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue().toString().contains(",") || entry.getValue().toString().contains(" ") || entry.getKey().equals("Description") ? "\"" + entry.getValue() + "\"" : entry.getValue());
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

