/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import net.sf.picard.fastq.ReadNameEncoder;
import net.sf.picard.illumina.parser.ClusterData;

public class IlluminaReadNameEncoder
implements ReadNameEncoder {
    final String runBarcode;

    public IlluminaReadNameEncoder(String string2) {
        this.runBarcode = string2;
    }

    @Override
    public String generateReadName(ClusterData clusterData, Integer n) {
        return this.runBarcode + ":" + clusterData.getLane() + ":" + clusterData.getTile() + ":" + clusterData.getX() + ":" + clusterData.getY() + IlluminaReadNameEncoder.generatePairNumberSuffix(n);
    }

    private static String generatePairNumberSuffix(Integer n) {
        if (n == null) {
            return "";
        }
        return "/" + n;
    }
}

