/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.Range;
import net.sf.picard.illumina.parser.ReadDescriptor;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.samtools.util.StringUtil;

public class OutputMapping {
    private final TwoDIndex[] cycleToOutputIndex;
    private final ReadStructure.Substructure outputSubstructure;
    private final ReadStructure outputReadStructure;

    public OutputMapping(ReadStructure readStructure) {
        this.outputSubstructure = readStructure.nonSkips;
        this.cycleToOutputIndex = this.makeCycleToOutputIndexArray(readStructure);
        this.outputReadStructure = this.outputSubstructure.toReadStructure();
    }

    public int numOutputReads() {
        return this.outputSubstructure.length();
    }

    public int[] getOutputCycles() {
        return this.outputSubstructure.getCycles();
    }

    public int[] getOutputReadLengths() {
        return this.outputSubstructure.getDescriptorLengths();
    }

    public int getTotalOutputCycles() {
        return this.outputSubstructure.getTotalCycles();
    }

    public Range[] getCycleIndexRanges() {
        return this.outputSubstructure.getCycleIndexRanges();
    }

    public Iterable<ReadDescriptor> getOutputDescriptors() {
        return this.outputSubstructure;
    }

    public ReadStructure getOutputReadStructure() {
        return this.outputReadStructure;
    }

    public TwoDIndex getOutputIndexForCycle(int n) {
        return this.cycleToOutputIndex[n];
    }

    private TwoDIndex[] makeCycleToOutputIndexArray(ReadStructure readStructure) {
        int n = readStructure.totalCycles;
        TwoDIndex[] twoDIndexArray = new TwoDIndex[n + 1];
        int[] nArray = this.getOutputCycles();
        int[] nArray2 = this.getOutputReadLengths();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i <= n && n2 < nArray.length; ++i) {
            if (nArray[n2] != i) continue;
            if (n4 >= nArray2[n3]) {
                n4 = 0;
                ++n3;
            }
            twoDIndexArray[i] = new TwoDIndex(n3, n4);
            ++n4;
            ++n2;
        }
        if (n2 != nArray.length) {
            throw new PicardException("Error in read structure outputCycles (" + StringUtil.intValuesToString(nArray) + ") and total cycles (" + n + ") OutputCycleIndex(" + n2 + ")");
        }
        return twoDIndexArray;
    }

    static class TwoDIndex {
        public final int majorIndex;
        public final int minorIndex;

        public TwoDIndex(int n, int n2) {
            this.majorIndex = n;
            this.minorIndex = n2;
        }

        public String toString() {
            return "TwoDIndex(majorIndex == " + this.majorIndex + ", minorIndex == " + this.minorIndex + ")";
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof TwoDIndex)) {
                return false;
            }
            TwoDIndex twoDIndex = (TwoDIndex)object;
            return this.majorIndex == twoDIndex.majorIndex && this.minorIndex == twoDIndex.minorIndex;
        }
    }
}

