/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.BuildBamIndex;
import net.sf.picard.util.Log;
import net.sf.samtools.BAMIndexMetaData;

public class BamIndexStats
extends CommandLineProgram {
    private static final Log log = Log.getInstance(BuildBamIndex.class);
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generates BAM index statistics. " + "Input BAM file must have a corresponding index file.\n";
    @Option(shortName="I", doc="A BAM file to process.")
    public File INPUT;

    public static void main(String[] stringArray) {
        System.exit(new BamIndexStats().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        if (this.INPUT.getName().endsWith(".bai")) {
            log.warn("INPUT should be BAM file not index file");
        }
        IoUtil.assertFileIsReadable(this.INPUT);
        BAMIndexMetaData.printIndexStats(this.INPUT);
        return 0;
    }
}

