/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;

public class MergeSamFiles
extends CommandLineProgram {
    private static final Log log = Log.getInstance(MergeSamFiles.class);
    @Usage
    public String USAGE = "Merges multiple SAM/BAM files into one file.\n";
    @Option(shortName="I", doc="SAM or BAM input file", minElements=1)
    public List<File> INPUT = new ArrayList<File>();
    @Option(shortName="O", doc="SAM or BAM file to write merged result to")
    public File OUTPUT;
    @Option(shortName="SO", doc="Sort order of output file", optional=true)
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.coordinate;
    @Option(doc="If true, assume that the input files are in the same sort order as the requested output sort order, even if their headers say otherwise.", shortName="AS")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="MSD", doc="Merge the sequence dictionaries", optional=true)
    public boolean MERGE_SEQUENCE_DICTIONARIES = false;
    @Option(doc="Option to create a background thread to encode, compress and write to disk the output file. The threaded version uses about 20% more CPU and decreases runtime by ~20% when writing out a compressed BAM file.")
    public boolean USE_THREADING = false;
    @Option(doc="Comment(s) to include in the merged output file's header.", optional=true, shortName="CO")
    public List<String> COMMENT = new ArrayList<String>();
    private static final int PROGRESS_INTERVAL = 1000000;

    public static void main(String[] stringArray) {
        System.exit(new MergeSamFiles().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        boolean bl3 = true;
        ArrayList<SAMFileReader> arrayList = new ArrayList<SAMFileReader>();
        ArrayList<SAMFileHeader> arrayList2 = new ArrayList<SAMFileHeader>();
        SAMSequenceDictionary sAMSequenceDictionary = null;
        for (File file : this.INPUT) {
            IoUtil.assertFileIsReadable(file);
            object3 = new SAMFileReader(file);
            arrayList.add((SAMFileReader)object3);
            arrayList2.add(((SAMFileReader)object3).getFileHeader());
            if (sAMSequenceDictionary == null) {
                sAMSequenceDictionary = ((SAMFileReader)object3).getFileHeader().getSequenceDictionary();
            } else if (sAMSequenceDictionary.equals(((SAMFileReader)object3).getFileHeader().getSequenceDictionary())) {
                ((SAMFileReader)object3).getFileHeader().setSequenceDictionary(sAMSequenceDictionary);
            }
            bl3 = bl3 && ((SAMFileReader)object3).getFileHeader().getSortOrder() == this.SORT_ORDER;
        }
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (bl3 || this.SORT_ORDER == SAMFileHeader.SortOrder.unsorted || this.ASSUME_SORTED) {
            log.info("Input files are in same order as output so sorting to temp directory is not needed.");
            object2 = this.SORT_ORDER;
            bl2 = this.ASSUME_SORTED;
            bl = true;
        } else {
            log.info("Sorting input files using temp directory " + this.TMP_DIR);
            object2 = SAMFileHeader.SortOrder.unsorted;
            bl2 = false;
            bl = false;
        }
        object3 = new SamFileHeaderMerger((SAMFileHeader.SortOrder)((Object)object2), (Collection<SAMFileHeader>)arrayList2, this.MERGE_SEQUENCE_DICTIONARIES);
        MergingSamRecordIterator mergingSamRecordIterator = new MergingSamRecordIterator((SamFileHeaderMerger)object3, arrayList, bl2);
        SAMFileHeader sAMFileHeader = ((SamFileHeaderMerger)object3).getMergedHeader();
        for (String object4 : this.COMMENT) {
            sAMFileHeader.addComment(object4);
        }
        sAMFileHeader.setSortOrder(this.SORT_ORDER);
        SAMFileWriterFactory sAMFileWriterFactory = new SAMFileWriterFactory();
        if (this.USE_THREADING) {
            sAMFileWriterFactory.setUseAsyncIo(true);
        }
        SAMFileWriter sAMFileWriter = sAMFileWriterFactory.makeSAMOrBAMWriter(sAMFileHeader, bl, this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000);
        while (mergingSamRecordIterator.hasNext()) {
            SAMRecord sAMRecord = mergingSamRecordIterator.next();
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        log.info("Finished reading inputs.");
        sAMFileWriter.close();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CREATE_INDEX.booleanValue() && this.SORT_ORDER != SAMFileHeader.SortOrder.coordinate) {
            return new String[]{"Can't CREATE_INDEX unless SORT_ORDER is coordinate"};
        }
        return null;
    }
}

