/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Collection;
import java.util.Map;
import java.util.PriorityQueue;
import net.sf.picard.PicardException;
import net.sf.picard.sam.ComparableSamRecordIterator;
import net.sf.picard.sam.ReservedTagConstants;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.util.CloseableIterator;

public class MergingSamRecordIterator
implements CloseableIterator<SAMRecord> {
    private final PriorityQueue<ComparableSamRecordIterator> pq;
    private final SamFileHeaderMerger samHeaderMerger;
    private final Collection<SAMFileReader> readers;
    private final SAMFileHeader.SortOrder sortOrder;
    private final SAMRecordComparator comparator;
    private boolean initialized = false;

    public MergingSamRecordIterator(SamFileHeaderMerger samFileHeaderMerger, boolean bl) {
        this(samFileHeaderMerger, samFileHeaderMerger.getReaders(), bl);
    }

    public MergingSamRecordIterator(SamFileHeaderMerger samFileHeaderMerger, Collection<SAMFileReader> collection, boolean bl) {
        this.samHeaderMerger = samFileHeaderMerger;
        this.sortOrder = samFileHeaderMerger.getMergedHeader().getSortOrder();
        this.comparator = this.getComparator();
        this.readers = collection;
        this.pq = new PriorityQueue(collection.size());
        for (SAMFileReader sAMFileReader : collection) {
            if (!this.samHeaderMerger.getHeaders().contains(sAMFileReader.getFileHeader())) {
                throw new PicardException("All iterators to be merged must be accounted for in the SAM header merger");
            }
            if (bl || this.sortOrder == SAMFileHeader.SortOrder.unsorted || sAMFileReader.getFileHeader().getSortOrder() == this.sortOrder) continue;
            throw new PicardException("Files are not compatible with sort order");
        }
    }

    public MergingSamRecordIterator(SamFileHeaderMerger samFileHeaderMerger, Map<SAMFileReader, CloseableIterator<SAMRecord>> map2, boolean bl) {
        this(samFileHeaderMerger, map2.keySet(), bl);
        for (Map.Entry<SAMFileReader, CloseableIterator<SAMRecord>> entry : map2.entrySet()) {
            this.addIfNotEmpty(new ComparableSamRecordIterator(entry.getKey(), entry.getValue(), this.comparator));
        }
        this.initialized = true;
    }

    private void startIterationIfRequired() {
        if (this.initialized) {
            return;
        }
        for (SAMFileReader sAMFileReader : this.readers) {
            this.addIfNotEmpty(new ComparableSamRecordIterator(sAMFileReader, sAMFileReader.iterator(), this.comparator));
        }
        this.initialized = true;
    }

    @Override
    public void close() {
        for (CloseableIterator closeableIterator : this.pq) {
            closeableIterator.close();
        }
    }

    @Override
    public boolean hasNext() {
        this.startIterationIfRequired();
        return !this.pq.isEmpty();
    }

    @Override
    public SAMRecord next() {
        String string2;
        String string3;
        this.startIterationIfRequired();
        ComparableSamRecordIterator comparableSamRecordIterator = this.pq.poll();
        SAMRecord sAMRecord = (SAMRecord)comparableSamRecordIterator.next();
        this.addIfNotEmpty(comparableSamRecordIterator);
        sAMRecord.setHeader(this.samHeaderMerger.getMergedHeader());
        if (this.samHeaderMerger.hasReadGroupCollisions() && (string3 = (String)sAMRecord.getAttribute(ReservedTagConstants.READ_GROUP_ID)) != null) {
            string2 = this.samHeaderMerger.getReadGroupId(comparableSamRecordIterator.getReader().getFileHeader(), string3);
            sAMRecord.setAttribute(ReservedTagConstants.READ_GROUP_ID, (Object)string2);
        }
        if (this.samHeaderMerger.hasProgramGroupCollisions() && (string3 = (String)sAMRecord.getAttribute(ReservedTagConstants.PROGRAM_GROUP_ID)) != null) {
            string2 = this.samHeaderMerger.getProgramGroupId(comparableSamRecordIterator.getReader().getFileHeader(), string3);
            sAMRecord.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)string2);
        }
        if (this.samHeaderMerger.hasMergedSequenceDictionary()) {
            if (sAMRecord.getReferenceIndex() != -1) {
                sAMRecord.setReferenceIndex(this.samHeaderMerger.getMergedSequenceIndex(comparableSamRecordIterator.getReader().getFileHeader(), sAMRecord.getReferenceIndex()));
            }
            if (sAMRecord.getReadPairedFlag() && sAMRecord.getMateReferenceIndex() != -1) {
                sAMRecord.setMateReferenceIndex(this.samHeaderMerger.getMergedSequenceIndex(comparableSamRecordIterator.getReader().getFileHeader(), sAMRecord.getMateReferenceIndex()));
            }
        }
        return sAMRecord;
    }

    private void addIfNotEmpty(ComparableSamRecordIterator comparableSamRecordIterator) {
        if (comparableSamRecordIterator.hasNext()) {
            this.pq.offer(comparableSamRecordIterator);
        } else {
            comparableSamRecordIterator.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("MergingSAMRecorderIterator.remove()");
    }

    private SAMRecordComparator getComparator() {
        if (this.sortOrder == SAMFileHeader.SortOrder.unsorted) {
            return new SAMRecordComparator(){

                @Override
                public int fileOrderCompare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
                    return System.identityHashCode(sAMRecord) - System.identityHashCode(sAMRecord2);
                }

                @Override
                public int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
                    return this.fileOrderCompare(sAMRecord, sAMRecord2);
                }
            };
        }
        if (this.samHeaderMerger.hasMergedSequenceDictionary() && this.sortOrder.equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            return new MergedSequenceDictionaryCoordinateOrderComparator();
        }
        return this.sortOrder.getComparatorInstance();
    }

    public SAMFileHeader getMergedHeader() {
        return this.samHeaderMerger.getMergedHeader();
    }

    private class MergedSequenceDictionaryCoordinateOrderComparator
    extends SAMRecordCoordinateComparator {
        private MergedSequenceDictionaryCoordinateOrderComparator() {
        }

        @Override
        public int fileOrderCompare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
            int n;
            int n2 = this.getReferenceIndex(sAMRecord);
            if (n2 != (n = this.getReferenceIndex(sAMRecord2))) {
                if (n2 == -1) {
                    return 1;
                }
                if (n == -1) {
                    return -1;
                }
                return n2 - n;
            }
            if (n2 == -1) {
                return 0;
            }
            return sAMRecord.getAlignmentStart() - sAMRecord2.getAlignmentStart();
        }

        private int getReferenceIndex(SAMRecord sAMRecord) {
            if (sAMRecord.getReferenceIndex() != -1) {
                return MergingSamRecordIterator.this.samHeaderMerger.getMergedSequenceIndex(sAMRecord.getHeader(), sAMRecord.getReferenceIndex());
            }
            if (sAMRecord.getMateReferenceIndex() != -1) {
                return MergingSamRecordIterator.this.samHeaderMerger.getMergedSequenceIndex(sAMRecord.getHeader(), sAMRecord.getMateReferenceIndex());
            }
            return -1;
        }
    }
}

