/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Iterator;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTag;

public class SamPairUtil {
    public static PairOrientation getPairOrientation(SAMRecord sAMRecord) {
        boolean bl = sAMRecord.getReadNegativeStrandFlag();
        if (sAMRecord.getReadUnmappedFlag() || !sAMRecord.getReadPairedFlag() || sAMRecord.getMateUnmappedFlag()) {
            throw new IllegalArgumentException("Invalid SAMRecord: " + sAMRecord.getReadName() + ". This method only works for SAMRecords " + "that are paired reads with both reads aligned.");
        }
        if (bl == sAMRecord.getMateNegativeStrandFlag()) {
            return PairOrientation.TANDEM;
        }
        long l = bl ? sAMRecord.getMateAlignmentStart() : sAMRecord.getAlignmentStart();
        long l2 = bl ? sAMRecord.getAlignmentEnd() : sAMRecord.getAlignmentStart() + sAMRecord.getInferredInsertSize();
        return l < l2 ? PairOrientation.FR : PairOrientation.RF;
    }

    public static boolean isProperPair(SAMRecord sAMRecord, SAMRecord sAMRecord2, List<PairOrientation> list) {
        if (sAMRecord.getReadUnmappedFlag() || sAMRecord2.getReadUnmappedFlag()) {
            return false;
        }
        if (sAMRecord.getReferenceName().equals("*")) {
            return false;
        }
        if (!sAMRecord.getReferenceName().equals(sAMRecord2.getReferenceName())) {
            return false;
        }
        PairOrientation pairOrientation = SamPairUtil.getPairOrientation(sAMRecord);
        return list.contains((Object)pairOrientation);
    }

    public static void assertMate(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        if (sAMRecord == null) {
            throw new PicardException("First record does not exist - cannot perform mate assertion!");
        }
        if (sAMRecord2 == null) {
            throw new PicardException(sAMRecord.toString() + " is missing its mate");
        }
        if (!sAMRecord.getReadPairedFlag()) {
            throw new PicardException("First record is not marked as paired: " + sAMRecord.toString());
        }
        if (!sAMRecord2.getReadPairedFlag()) {
            throw new PicardException("Second record is not marked as paired: " + sAMRecord2.toString());
        }
        if (!sAMRecord.getFirstOfPairFlag()) {
            throw new PicardException("First record is not marked as first of pair: " + sAMRecord.toString());
        }
        if (!sAMRecord2.getSecondOfPairFlag()) {
            throw new PicardException("Second record is not marked as second of pair: " + sAMRecord2.toString());
        }
        if (!sAMRecord.getReadName().equals(sAMRecord2.getReadName())) {
            throw new PicardException("First [" + sAMRecord.getReadName() + "] and Second [" + sAMRecord2.getReadName() + "] readnames do not match!");
        }
    }

    public static SAMRecord obtainAssertedMate(Iterator<SAMRecord> iterator2, SAMRecord sAMRecord) {
        if (iterator2.hasNext()) {
            SAMRecord sAMRecord2 = iterator2.next();
            SamPairUtil.assertMate(sAMRecord, sAMRecord2);
            return sAMRecord2;
        }
        throw new PicardException("Second record does not exist: " + sAMRecord.getReadName());
    }

    public static int computeInsertSize(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        if (sAMRecord.getReadUnmappedFlag() || sAMRecord2.getReadUnmappedFlag()) {
            return 0;
        }
        if (!sAMRecord.getReferenceName().equals(sAMRecord2.getReferenceName())) {
            return 0;
        }
        int n = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord.getAlignmentEnd() : sAMRecord.getAlignmentStart();
        int n2 = sAMRecord2.getReadNegativeStrandFlag() ? sAMRecord2.getAlignmentEnd() : sAMRecord2.getAlignmentStart();
        int n3 = n2 >= n ? 1 : -1;
        return n2 - n + n3;
    }

    public static void setMateInfo(SAMRecord sAMRecord, SAMRecord sAMRecord2, SAMFileHeader sAMFileHeader) {
        if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord2.getReadUnmappedFlag()) {
            sAMRecord.setMateReferenceIndex(sAMRecord2.getReferenceIndex());
            sAMRecord.setMateAlignmentStart(sAMRecord2.getAlignmentStart());
            sAMRecord.setMateNegativeStrandFlag(sAMRecord2.getReadNegativeStrandFlag());
            sAMRecord.setMateUnmappedFlag(false);
            sAMRecord.setAttribute(SAMTag.MQ.name(), (Object)sAMRecord2.getMappingQuality());
            sAMRecord2.setMateReferenceIndex(sAMRecord.getReferenceIndex());
            sAMRecord2.setMateAlignmentStart(sAMRecord.getAlignmentStart());
            sAMRecord2.setMateNegativeStrandFlag(sAMRecord.getReadNegativeStrandFlag());
            sAMRecord2.setMateUnmappedFlag(false);
            sAMRecord2.setAttribute(SAMTag.MQ.name(), (Object)sAMRecord.getMappingQuality());
        } else if (sAMRecord.getReadUnmappedFlag() && sAMRecord2.getReadUnmappedFlag()) {
            sAMRecord.setReferenceIndex(-1);
            sAMRecord.setAlignmentStart(0);
            sAMRecord.setMateReferenceIndex(-1);
            sAMRecord.setMateAlignmentStart(0);
            sAMRecord.setMateNegativeStrandFlag(sAMRecord2.getReadNegativeStrandFlag());
            sAMRecord.setMateUnmappedFlag(true);
            sAMRecord.setAttribute(SAMTag.MQ.name(), null);
            sAMRecord.setInferredInsertSize(0);
            sAMRecord2.setReferenceIndex(-1);
            sAMRecord2.setAlignmentStart(0);
            sAMRecord2.setMateReferenceIndex(-1);
            sAMRecord2.setMateAlignmentStart(0);
            sAMRecord2.setMateNegativeStrandFlag(sAMRecord.getReadNegativeStrandFlag());
            sAMRecord2.setMateUnmappedFlag(true);
            sAMRecord2.setAttribute(SAMTag.MQ.name(), null);
            sAMRecord2.setInferredInsertSize(0);
        } else {
            SAMRecord sAMRecord3 = sAMRecord.getReadUnmappedFlag() ? sAMRecord2 : sAMRecord;
            SAMRecord sAMRecord4 = sAMRecord.getReadUnmappedFlag() ? sAMRecord : sAMRecord2;
            sAMRecord4.setReferenceIndex(sAMRecord3.getReferenceIndex());
            sAMRecord4.setAlignmentStart(sAMRecord3.getAlignmentStart());
            sAMRecord3.setMateReferenceIndex(sAMRecord4.getReferenceIndex());
            sAMRecord3.setMateAlignmentStart(sAMRecord4.getAlignmentStart());
            sAMRecord3.setMateNegativeStrandFlag(sAMRecord4.getReadNegativeStrandFlag());
            sAMRecord3.setMateUnmappedFlag(true);
            sAMRecord3.setInferredInsertSize(0);
            sAMRecord4.setMateReferenceIndex(sAMRecord3.getReferenceIndex());
            sAMRecord4.setMateAlignmentStart(sAMRecord3.getAlignmentStart());
            sAMRecord4.setMateNegativeStrandFlag(sAMRecord3.getReadNegativeStrandFlag());
            sAMRecord4.setMateUnmappedFlag(false);
            sAMRecord4.setInferredInsertSize(0);
        }
        int n = SamPairUtil.computeInsertSize(sAMRecord, sAMRecord2);
        sAMRecord.setInferredInsertSize(n);
        sAMRecord2.setInferredInsertSize(-n);
    }

    public static void setProperPairAndMateInfo(SAMRecord sAMRecord, SAMRecord sAMRecord2, SAMFileHeader sAMFileHeader, List<PairOrientation> list) {
        SamPairUtil.setMateInfo(sAMRecord, sAMRecord2, sAMFileHeader);
        SamPairUtil.setProperPairFlags(sAMRecord, sAMRecord2, list);
    }

    public static void setProperPairFlags(SAMRecord sAMRecord, SAMRecord sAMRecord2, List<PairOrientation> list) {
        boolean bl = !sAMRecord.getReadUnmappedFlag() && !sAMRecord2.getReadUnmappedFlag() ? SamPairUtil.isProperPair(sAMRecord, sAMRecord2, list) : false;
        sAMRecord.setProperPairFlag(bl);
        sAMRecord2.setProperPairFlag(bl);
    }

    public static enum PairOrientation {
        FR,
        RF,
        TANDEM;

    }
}

