/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.picard.sam.SamFileValidator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMValidationError;

public class ValidateSamFile
extends CommandLineProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Read a SAM or BAM file and report on its validity.";
    @Option(shortName="I", doc="Input SAM/BAM file")
    public File INPUT;
    @Option(shortName="O", doc="Output file or standard out if missing", optional=true)
    public File OUTPUT;
    @Option(shortName="M", doc="Mode of output")
    public Mode MODE = Mode.VERBOSE;
    @Option(doc="List of validation error types to ignore.")
    public List<SAMValidationError.Type> IGNORE = new ArrayList<SAMValidationError.Type>();
    @Option(shortName="MO", doc="The maximum number of lines output in verbose mode")
    public Integer MAX_OUTPUT = 100;
    @Option(shortName="R", doc="Reference sequence file, the NM tag check will be skipped if this is missing", optional=true)
    public File REFERENCE_SEQUENCE;
    @Option(doc="If true, only report errors and ignore warnings.")
    public boolean IGNORE_WARNINGS = false;
    @Option(doc="If true and input is a BAM file with an index file, also validates the index.")
    public boolean VALIDATE_INDEX = true;
    @Option(shortName="BISULFITE", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads. If so, C->T is not counted as an error in computing the value of the NM tag.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Option(doc="Relevant for a coordinate-sorted file containing read pairs only. Maximum number of file handles to keep open when spilling mate info to disk. Set this number a little lower than the per-process maximum number of file that may be open. This number can be found by executing the 'ulimit -n' command on a Unix system.")
    public int MAX_OPEN_TEMP_FILES = 8000;

    public static void main(String[] stringArray) {
        System.exit(new ValidateSamFile().instanceMain(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() {
        boolean bl;
        PrintWriter printWriter;
        IoUtil.assertFileIsReadable(this.INPUT);
        ReferenceSequenceFile referenceSequenceFile = null;
        if (this.REFERENCE_SEQUENCE != null) {
            IoUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
            referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
        }
        if (this.OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
            try {
                printWriter = new PrintWriter(this.OUTPUT);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PicardException("Unexpected exception", fileNotFoundException);
            }
        } else {
            printWriter = new PrintWriter(System.out);
        }
        SAMFileReader.ValidationStringency validationStringency = SAMFileReader.getDefaultValidationStringency();
        SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        try {
            SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT);
            if (!sAMFileReader.isBinary()) {
                this.VALIDATE_INDEX = false;
            }
            if (this.VALIDATE_INDEX) {
                sAMFileReader.enableIndexCaching(true);
            }
            sAMFileReader.enableCrcChecking(true);
            SamFileValidator samFileValidator = new SamFileValidator(printWriter, this.MAX_OPEN_TEMP_FILES);
            samFileValidator.setErrorsToIgnore(this.IGNORE);
            if (this.IGNORE_WARNINGS) {
                samFileValidator.setIgnoreWarnings(this.IGNORE_WARNINGS);
            }
            if (this.MODE == Mode.SUMMARY) {
                samFileValidator.setVerbose(false, 0);
            } else {
                samFileValidator.setVerbose(true, this.MAX_OUTPUT);
            }
            if (this.IS_BISULFITE_SEQUENCED) {
                samFileValidator.setBisulfiteSequenced(this.IS_BISULFITE_SEQUENCED);
            }
            if (this.VALIDATE_INDEX) {
                samFileValidator.setValidateIndex(this.VALIDATE_INDEX);
            }
            if (IoUtil.isRegularPath(this.INPUT)) {
                samFileValidator.validateBamFileTermination(this.INPUT);
            }
            bl = false;
            switch (this.MODE) {
                case SUMMARY: {
                    bl = samFileValidator.validateSamFileSummary(sAMFileReader, referenceSequenceFile);
                    break;
                }
                case VERBOSE: {
                    bl = samFileValidator.validateSamFileVerbose(sAMFileReader, referenceSequenceFile);
                }
            }
            printWriter.flush();
        }
        finally {
            SAMFileReader.setDefaultValidationStringency(validationStringency);
        }
        return bl ? 0 : 1;
    }

    public static enum Mode {
        VERBOSE,
        SUMMARY;

    }
}

