/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalUtil;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

class SamRecordIntervalIterator
implements CloseableIterator<SAMRecord> {
    private static final int DEFAULT_MAX_READ_LENGTH_GUESS = 16384;
    private final SAMFileReader samReader;
    private final Iterator<Interval> mergedIntervalsIterator;
    private PeekableIterator<SAMRecord> samIterator = null;
    private int lastSequenceIndex = -1;
    private int lastPosition = -1;

    public SamRecordIntervalIterator(SAMFileReader sAMFileReader, List<Interval> list) {
        this(sAMFileReader, list, 16384);
    }

    public SamRecordIntervalIterator(SAMFileReader sAMFileReader, List<Interval> list, int n) {
        IntervalUtil.assertOrderedNonOverlapping(list.iterator(), sAMFileReader.getFileHeader().getSequenceDictionary());
        if (!sAMFileReader.hasIndex()) {
            throw new IllegalArgumentException("SAMFileReader does not support query");
        }
        this.samReader = sAMFileReader;
        this.mergedIntervalsIterator = this.mergeCloseIntervals(list, n).iterator();
        this.advanceInterval();
    }

    private List<Interval> mergeCloseIntervals(List<Interval> list, int n) {
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        if (list.isEmpty()) {
            return arrayList;
        }
        Interval interval = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            Interval interval2 = list.get(i);
            if (!interval.getSequence().equals(interval2.getSequence()) || interval2.getStart() - interval.getEnd() > n) {
                arrayList.add(interval);
                interval = interval2;
                continue;
            }
            interval = new Interval(interval.getSequence(), interval.getStart(), interval2.getEnd());
        }
        arrayList.add(interval);
        return arrayList;
    }

    private void advanceInterval() {
        if (this.samIterator != null) {
            this.samIterator.close();
        }
        this.samIterator = null;
        while (this.mergedIntervalsIterator.hasNext()) {
            Interval interval = this.mergedIntervalsIterator.next();
            this.samIterator = new PeekableIterator<SAMRecord>(this.samReader.queryOverlapping(interval.getSequence(), interval.getStart(), interval.getEnd()));
            this.advanceSamIterator();
            if (this.samIterator.hasNext()) break;
            this.samIterator.close();
            this.samIterator = null;
        }
    }

    private void advanceSamIterator() {
        SAMRecord sAMRecord;
        while (this.samIterator.hasNext() && (sAMRecord = this.samIterator.peek()).getReferenceIndex() <= this.lastSequenceIndex && sAMRecord.getAlignmentStart() <= this.lastPosition) {
            this.samIterator.next();
        }
    }

    @Override
    public void close() {
        if (this.samIterator != null) {
            this.samIterator.close();
            this.samIterator = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.samIterator != null && this.samIterator.hasNext();
    }

    @Override
    public SAMRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SAMRecord sAMRecord = this.samIterator.next();
        this.lastSequenceIndex = sAMRecord.getReferenceIndex();
        this.lastPosition = sAMRecord.getAlignmentStart();
        if (!this.samIterator.hasNext()) {
            this.advanceInterval();
        }
        return sAMRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported: remove");
    }
}

