/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.sf.samtools.BAMRecord;
import net.sf.samtools.BinaryCigarCodec;
import net.sf.samtools.BinaryTagCodec;
import net.sf.samtools.DefaultSAMRecordFactory;
import net.sf.samtools.SAMBinaryTagAndValue;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordFactory;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.BinaryCodec;
import net.sf.samtools.util.RuntimeEOFException;
import net.sf.samtools.util.SortingCollection;

public class BAMRecordCodec
implements SortingCollection.Codec<SAMRecord> {
    private final BinaryCigarCodec cigarCodec = new BinaryCigarCodec();
    private final SAMFileHeader header;
    private final BinaryCodec binaryCodec = new BinaryCodec();
    private final BinaryTagCodec binaryTagCodec = new BinaryTagCodec(this.binaryCodec);
    private final SAMRecordFactory samRecordFactory;

    public BAMRecordCodec(SAMFileHeader sAMFileHeader) {
        this(sAMFileHeader, new DefaultSAMRecordFactory());
    }

    public BAMRecordCodec(SAMFileHeader sAMFileHeader, SAMRecordFactory sAMRecordFactory) {
        this.header = sAMFileHeader;
        this.samRecordFactory = sAMRecordFactory;
    }

    public BAMRecordCodec clone() {
        return new BAMRecordCodec(this.header, this.samRecordFactory);
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.binaryCodec.setOutputStream(outputStream);
    }

    public void setOutputStream(OutputStream outputStream, String string2) {
        this.binaryCodec.setOutputStream(outputStream);
        this.binaryCodec.setOutputFileName(string2);
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.binaryCodec.setInputStream(inputStream);
    }

    public void setInputStream(InputStream inputStream, String string2) {
        this.binaryCodec.setInputStream(inputStream);
        this.binaryCodec.setInputFileName(string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void encode(SAMRecord sAMRecord) {
        int n = sAMRecord.getReadLength();
        int n2 = sAMRecord.getCigarLength();
        int n3 = 32 + sAMRecord.getReadNameLength() + 1 + n2 * 4 + (n + 1) / 2 + n;
        int n4 = sAMRecord.getAttributesBinarySize();
        if (n4 != -1) {
            n3 += n4;
        } else {
            for (SAMBinaryTagAndValue sAMBinaryTagAndValue = sAMRecord.getBinaryAttributes(); sAMBinaryTagAndValue != null; sAMBinaryTagAndValue = sAMBinaryTagAndValue.getNext()) {
                n3 += BinaryTagCodec.getTagSize(sAMBinaryTagAndValue.value);
            }
        }
        int n5 = 0;
        if (sAMRecord.getReferenceIndex() >= 0) {
            n5 = sAMRecord.getIndexingBin() != null ? sAMRecord.getIndexingBin().intValue() : sAMRecord.computeIndexingBin();
        }
        this.binaryCodec.writeInt(n3);
        this.binaryCodec.writeInt(sAMRecord.getReferenceIndex());
        this.binaryCodec.writeInt(sAMRecord.getAlignmentStart() - 1);
        this.binaryCodec.writeUByte((short)(sAMRecord.getReadNameLength() + 1));
        this.binaryCodec.writeUByte((short)sAMRecord.getMappingQuality());
        this.binaryCodec.writeUShort(n5);
        this.binaryCodec.writeUShort(n2);
        this.binaryCodec.writeUShort(sAMRecord.getFlags());
        this.binaryCodec.writeInt(sAMRecord.getReadLength());
        this.binaryCodec.writeInt(sAMRecord.getMateReferenceIndex());
        this.binaryCodec.writeInt(sAMRecord.getMateAlignmentStart() - 1);
        this.binaryCodec.writeInt(sAMRecord.getInferredInsertSize());
        byte[] byArray = sAMRecord.getVariableBinaryRepresentation();
        if (byArray != null) {
            this.binaryCodec.writeBytes(byArray);
        } else {
            void var9_13;
            int[] nArray;
            if (sAMRecord.getReadLength() != sAMRecord.getBaseQualities().length && sAMRecord.getBaseQualities().length != 0) {
                throw new RuntimeException("Mismatch between read length and quals length writing read " + sAMRecord.getReadName() + "; read length: " + sAMRecord.getReadLength() + "; quals length: " + sAMRecord.getBaseQualities().length);
            }
            this.binaryCodec.writeString(sAMRecord.getReadName(), false, true);
            for (int n6 : nArray = this.cigarCodec.encode(sAMRecord.getCigar())) {
                this.binaryCodec.writeInt(n6);
            }
            this.binaryCodec.writeBytes(SAMUtils.bytesToCompressedBases(sAMRecord.getReadBases()));
            byte[] byArray2 = sAMRecord.getBaseQualities();
            if (byArray2.length == 0) {
                byte[] byArray3 = new byte[sAMRecord.getReadLength()];
                Arrays.fill(byArray3, (byte)-1);
            }
            this.binaryCodec.writeBytes((byte[])var9_13);
            for (SAMBinaryTagAndValue sAMBinaryTagAndValue = sAMRecord.getBinaryAttributes(); sAMBinaryTagAndValue != null; sAMBinaryTagAndValue = sAMBinaryTagAndValue.getNext()) {
                this.binaryTagCodec.writeTag(sAMBinaryTagAndValue.tag, sAMBinaryTagAndValue.value, sAMBinaryTagAndValue.isUnsignedArray());
            }
        }
    }

    @Override
    public SAMRecord decode() {
        int n = 0;
        try {
            n = this.binaryCodec.readInt();
        }
        catch (RuntimeEOFException runtimeEOFException) {
            return null;
        }
        if (n < 32) {
            throw new SAMFormatException("Invalid record length: " + n);
        }
        int n2 = this.binaryCodec.readInt();
        int n3 = this.binaryCodec.readInt() + 1;
        short s2 = this.binaryCodec.readUByte();
        short s3 = this.binaryCodec.readUByte();
        int n4 = this.binaryCodec.readUShort();
        int n5 = this.binaryCodec.readUShort();
        int n6 = this.binaryCodec.readUShort();
        int n7 = this.binaryCodec.readInt();
        int n8 = this.binaryCodec.readInt();
        int n9 = this.binaryCodec.readInt() + 1;
        int n10 = this.binaryCodec.readInt();
        byte[] byArray = new byte[n - 32];
        this.binaryCodec.readBytes(byArray);
        BAMRecord bAMRecord = this.samRecordFactory.createBAMRecord(this.header, n2, n3, s2, s3, n4, n5, n6, n7, n8, n9, n10, byArray);
        bAMRecord.setHeader(this.header);
        return bAMRecord;
    }
}

