/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.Chunk;

public class Bin
implements Comparable<Bin> {
    private final int referenceSequence;
    private final int binNumber;
    private List<Chunk> chunkList;
    private Chunk lastChunk;

    public Bin(int n, int n2) {
        this.referenceSequence = n;
        this.binNumber = n2;
    }

    protected int getReferenceSequence() {
        return this.referenceSequence;
    }

    protected int getBinNumber() {
        return this.binNumber;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Bin)) {
            return false;
        }
        Bin bin = (Bin)object;
        return this.referenceSequence == bin.referenceSequence && this.binNumber == bin.binNumber;
    }

    public int hashCode() {
        return Integer.valueOf(this.referenceSequence).hashCode() ^ Integer.valueOf(this.binNumber).hashCode();
    }

    public boolean containsChunks() {
        return this.chunkList != null;
    }

    @Override
    public int compareTo(Bin bin) {
        if (bin == null) {
            throw new ClassCastException("Cannot compare to a null object");
        }
        if (this.referenceSequence != bin.referenceSequence) {
            return this.referenceSequence - bin.referenceSequence;
        }
        return this.binNumber - bin.binNumber;
    }

    public void addInitialChunk(Chunk chunk) {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        this.setChunkList(arrayList);
        this.setLastChunk(chunk);
        arrayList.add(chunk);
    }

    public void setChunkList(List<Chunk> list) {
        this.chunkList = list;
    }

    public List<Chunk> getChunkList() {
        if (this.chunkList == null) {
            return Collections.emptyList();
        }
        return this.chunkList;
    }

    public void setLastChunk(Chunk chunk) {
        this.lastChunk = chunk;
    }

    public Chunk getLastChunk() {
        return this.lastChunk;
    }
}

