/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.StringWriter;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMSortOrderChecker;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.SortingCollection;

public abstract class SAMFileWriterImpl
implements SAMFileWriter {
    private static int DEAFULT_MAX_RECORDS_IN_RAM = 500000;
    private int maxRecordsInRam = DEAFULT_MAX_RECORDS_IN_RAM;
    private SAMFileHeader.SortOrder sortOrder;
    private SAMFileHeader header;
    private SortingCollection<SAMRecord> alignmentSorter;
    private File tmpDir = new File(System.getProperty("java.io.tmpdir"));
    private boolean presorted;
    private SAMSortOrderChecker sortOrderChecker;

    public static void setDefaultMaxRecordsInRam(int n) {
        DEAFULT_MAX_RECORDS_IN_RAM = n;
    }

    public static int getDefaultMaxRecordsInRam() {
        return DEAFULT_MAX_RECORDS_IN_RAM;
    }

    public void setSortOrder(SAMFileHeader.SortOrder sortOrder, boolean bl) {
        if (this.header != null) {
            throw new IllegalStateException("Cannot call SAMFileWriterImpl.setSortOrder after setHeader for " + this.getFilename());
        }
        this.sortOrder = sortOrder;
        this.presorted = bl;
    }

    protected SAMFileHeader.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    void setMaxRecordsInRam(int n) {
        if (this.header != null) {
            throw new IllegalStateException("setMaxRecordsInRam must be called before setHeader()");
        }
        this.maxRecordsInRam = n;
    }

    void setTempDirectory(File file) {
        if (file != null) {
            this.tmpDir = file;
        }
    }

    public void setHeader(SAMFileHeader sAMFileHeader) {
        this.header = sAMFileHeader;
        if (this.sortOrder == null) {
            this.sortOrder = SAMFileHeader.SortOrder.unsorted;
        }
        sAMFileHeader.setSortOrder(this.sortOrder);
        StringWriter stringWriter = new StringWriter();
        new SAMTextHeaderCodec().encode(stringWriter, sAMFileHeader);
        String string2 = stringWriter.toString();
        this.writeHeader(string2);
        if (this.presorted) {
            if (this.sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted)) {
                this.presorted = false;
            } else {
                this.sortOrderChecker = new SAMSortOrderChecker(this.sortOrder);
            }
        } else if (!this.sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted)) {
            this.alignmentSorter = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(sAMFileHeader), this.makeComparator(), this.maxRecordsInRam, this.tmpDir);
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.header;
    }

    private SAMRecordComparator makeComparator() {
        switch (this.sortOrder) {
            case coordinate: {
                return new SAMRecordCoordinateComparator();
            }
            case queryname: {
                return new SAMRecordQueryNameComparator();
            }
            case unsorted: {
                return null;
            }
        }
        throw new IllegalStateException("sortOrder should not be null");
    }

    @Override
    public void addAlignment(SAMRecord sAMRecord) {
        if (this.sortOrder.equals((Object)SAMFileHeader.SortOrder.unsorted)) {
            if (!this.header.getGroupOrder().equals((Object)SAMFileHeader.GroupOrder.none)) {
                throw new UnsupportedOperationException("GroupOrder " + (Object)((Object)this.header.getGroupOrder()) + " is not supported");
            }
            this.writeAlignment(sAMRecord);
        } else if (this.presorted) {
            this.assertPresorted(sAMRecord);
            this.writeAlignment(sAMRecord);
        } else {
            this.alignmentSorter.add(sAMRecord);
        }
    }

    private void assertPresorted(SAMRecord sAMRecord) {
        SAMRecord sAMRecord2 = this.sortOrderChecker.getPreviousRecord();
        if (!this.sortOrderChecker.isSorted(sAMRecord)) {
            throw new IllegalArgumentException("Alignments added out of order in SAMFileWriterImpl.addAlignment for " + this.getFilename() + ". Sort order is " + (Object)((Object)this.sortOrder) + ". Offending records are at [" + this.sortOrderChecker.getSortKey(sAMRecord2) + "] and [" + this.sortOrderChecker.getSortKey(sAMRecord) + "]");
        }
    }

    @Override
    public final void close() {
        if (this.alignmentSorter != null) {
            for (SAMRecord sAMRecord : this.alignmentSorter) {
                this.writeAlignment(sAMRecord);
            }
            this.alignmentSorter.cleanup();
        }
        this.finish();
    }

    protected abstract void writeAlignment(SAMRecord var1);

    protected abstract void writeHeader(String var1);

    protected abstract void finish();

    protected abstract String getFilename();
}

