/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordUtil;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.util.StringUtil;

public final class SAMUtils {
    private static final byte COMPRESSED_EQUAL_LOW = 0;
    private static final byte COMPRESSED_A_LOW = 1;
    private static final byte COMPRESSED_C_LOW = 2;
    private static final byte COMPRESSED_M_LOW = 3;
    private static final byte COMPRESSED_G_LOW = 4;
    private static final byte COMPRESSED_R_LOW = 5;
    private static final byte COMPRESSED_S_LOW = 6;
    private static final byte COMPRESSED_V_LOW = 7;
    private static final byte COMPRESSED_T_LOW = 8;
    private static final byte COMPRESSED_W_LOW = 9;
    private static final byte COMPRESSED_Y_LOW = 10;
    private static final byte COMPRESSED_H_LOW = 11;
    private static final byte COMPRESSED_K_LOW = 12;
    private static final byte COMPRESSED_D_LOW = 13;
    private static final byte COMPRESSED_B_LOW = 14;
    private static final byte COMPRESSED_N_LOW = 15;
    private static final byte COMPRESSED_EQUAL_HIGH = 0;
    private static final byte COMPRESSED_A_HIGH = 16;
    private static final byte COMPRESSED_C_HIGH = 32;
    private static final byte COMPRESSED_G_HIGH = 64;
    private static final byte COMPRESSED_T_HIGH = -128;
    private static final byte COMPRESSED_N_HIGH = -16;
    private static final byte COMPRESSED_M_HIGH = 48;
    private static final byte COMPRESSED_R_HIGH = 80;
    private static final byte COMPRESSED_S_HIGH = 96;
    private static final byte COMPRESSED_V_HIGH = 112;
    private static final byte COMPRESSED_W_HIGH = -112;
    private static final byte COMPRESSED_Y_HIGH = -96;
    private static final byte COMPRESSED_H_HIGH = -80;
    private static final byte COMPRESSED_K_HIGH = -64;
    private static final byte COMPRESSED_D_HIGH = -48;
    private static final byte COMPRESSED_B_HIGH = -32;
    public static final int MAX_PHRED_SCORE = 93;

    static byte[] bytesToCompressedBases(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[(byArray.length + 1) / 2];
        for (n = 1; n < byArray.length; n += 2) {
            byArray2[n / 2] = (byte)(SAMUtils.charToCompressedBaseHigh(byArray[n - 1]) | SAMUtils.charToCompressedBaseLow(byArray[n]));
        }
        if (n == byArray.length) {
            byArray2[n / 2] = SAMUtils.charToCompressedBaseHigh((char)byArray[n - 1]);
        }
        return byArray2;
    }

    public static byte[] compressedBasesToBytes(int n, byte[] byArray, int n2) {
        int n3;
        byte[] byArray2 = new byte[n];
        for (n3 = 1; n3 < n; n3 += 2) {
            int n4 = n3 / 2 + n2;
            byArray2[n3 - 1] = SAMUtils.compressedBaseToByteHigh(byArray[n4]);
            byArray2[n3] = SAMUtils.compressedBaseToByteLow(byArray[n4]);
        }
        if (n3 == n) {
            byArray2[n3 - 1] = SAMUtils.compressedBaseToByteHigh(byArray[n3 / 2 + n2]);
        }
        return byArray2;
    }

    private static byte charToCompressedBaseLow(int n) {
        switch (n) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 1;
            }
            case 67: 
            case 99: {
                return 2;
            }
            case 71: 
            case 103: {
                return 4;
            }
            case 84: 
            case 116: {
                return 8;
            }
            case 46: 
            case 78: 
            case 110: {
                return 15;
            }
            case 77: 
            case 109: {
                return 3;
            }
            case 82: 
            case 114: {
                return 5;
            }
            case 83: 
            case 115: {
                return 6;
            }
            case 86: 
            case 118: {
                return 7;
            }
            case 87: 
            case 119: {
                return 9;
            }
            case 89: 
            case 121: {
                return 10;
            }
            case 72: 
            case 104: {
                return 11;
            }
            case 75: 
            case 107: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 66: 
            case 98: {
                return 14;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + n);
    }

    private static byte charToCompressedBaseHigh(int n) {
        switch (n) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 16;
            }
            case 67: 
            case 99: {
                return 32;
            }
            case 71: 
            case 103: {
                return 64;
            }
            case 84: 
            case 116: {
                return -128;
            }
            case 46: 
            case 78: 
            case 110: {
                return -16;
            }
            case 77: 
            case 109: {
                return 48;
            }
            case 82: 
            case 114: {
                return 80;
            }
            case 83: 
            case 115: {
                return 96;
            }
            case 86: 
            case 118: {
                return 112;
            }
            case 87: 
            case 119: {
                return -112;
            }
            case 89: 
            case 121: {
                return -96;
            }
            case 72: 
            case 104: {
                return -80;
            }
            case 75: 
            case 107: {
                return -64;
            }
            case 68: 
            case 100: {
                return -48;
            }
            case 66: 
            case 98: {
                return -32;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + n);
    }

    private static byte compressedBaseToByteLow(int n) {
        switch (n & 0xF) {
            case 0: {
                return 61;
            }
            case 1: {
                return 65;
            }
            case 2: {
                return 67;
            }
            case 4: {
                return 71;
            }
            case 8: {
                return 84;
            }
            case 15: {
                return 78;
            }
            case 3: {
                return 77;
            }
            case 5: {
                return 82;
            }
            case 6: {
                return 83;
            }
            case 7: {
                return 86;
            }
            case 9: {
                return 87;
            }
            case 10: {
                return 89;
            }
            case 11: {
                return 72;
            }
            case 12: {
                return 75;
            }
            case 13: {
                return 68;
            }
            case 14: {
                return 66;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + n);
    }

    private static byte compressedBaseToByteHigh(int n) {
        switch ((byte)(n & 0xF0)) {
            case 0: {
                return 61;
            }
            case 16: {
                return 65;
            }
            case 32: {
                return 67;
            }
            case 64: {
                return 71;
            }
            case -128: {
                return 84;
            }
            case -16: {
                return 78;
            }
            case 48: {
                return 77;
            }
            case 80: {
                return 82;
            }
            case 96: {
                return 83;
            }
            case 112: {
                return 86;
            }
            case -112: {
                return 87;
            }
            case -96: {
                return 89;
            }
            case -80: {
                return 72;
            }
            case -64: {
                return 75;
            }
            case -48: {
                return 68;
            }
            case -32: {
                return 66;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + n);
    }

    static void normalizeBases(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = StringUtil.toUpperCase(byArray[i]);
            if (byArray[i] != 46) continue;
            byArray[i] = 78;
        }
    }

    public static String phredToFastq(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return SAMUtils.phredToFastq(byArray, 0, byArray.length);
    }

    public static String phredToFastq(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = SAMUtils.phredToFastq(byArray[n + i] & 0xFF);
        }
        return new String(cArray);
    }

    public static char phredToFastq(int n) {
        if (n < 0 || n > 93) {
            throw new IllegalArgumentException("Cannot encode phred score: " + n);
        }
        return (char)(33 + n);
    }

    public static byte[] fastqToPhred(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)SAMUtils.fastqToPhred(string2.charAt(i));
        }
        return byArray;
    }

    public static void fastqToPhred(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)SAMUtils.fastqToPhred((char)(byArray[i] & 0xFF));
        }
    }

    public static int fastqToPhred(char c) {
        if (c < '!' || c > '~') {
            throw new IllegalArgumentException("Invalid fastq character: " + c);
        }
        return c - 33;
    }

    static int reg2bin(int n, int n2) {
        if (n >> 14 == --n2 >> 14) {
            return 4681 + (n >> 14);
        }
        if (n >> 17 == n2 >> 17) {
            return 585 + (n >> 17);
        }
        if (n >> 20 == n2 >> 20) {
            return 73 + (n >> 20);
        }
        if (n >> 23 == n2 >> 23) {
            return 9 + (n >> 23);
        }
        if (n >> 26 == n2 >> 26) {
            return 1 + (n >> 26);
        }
        return 0;
    }

    static void processValidationErrors(List<SAMValidationError> list, long l, SAMFileReader.ValidationStringency validationStringency) {
        if (list != null && list.size() > 0) {
            for (SAMValidationError sAMValidationError : list) {
                sAMValidationError.setRecordNumber(l);
            }
            if (validationStringency == SAMFileReader.ValidationStringency.STRICT) {
                throw new SAMFormatException("SAM validation error: " + list.get(0));
            }
            if (validationStringency == SAMFileReader.ValidationStringency.LENIENT) {
                for (SAMValidationError sAMValidationError : list) {
                    System.err.println("Ignoring SAM validation error: " + sAMValidationError);
                }
            }
        }
    }

    static void processValidationError(SAMValidationError sAMValidationError, SAMFileReader.ValidationStringency validationStringency) {
        if (validationStringency == SAMFileReader.ValidationStringency.STRICT) {
            throw new SAMFormatException("SAM validation error: " + sAMValidationError);
        }
        if (validationStringency == SAMFileReader.ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error: " + sAMValidationError);
        }
    }

    public static void chainSAMProgramRecord(SAMFileHeader sAMFileHeader, SAMProgramRecord sAMProgramRecord) {
        List<SAMProgramRecord> list = sAMFileHeader.getProgramRecords();
        if (list.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SAMProgramRecord sAMProgramRecord2 : list) {
                if (sAMProgramRecord2.getPreviousProgramGroupId() == null) continue;
                arrayList.add(sAMProgramRecord2.getPreviousProgramGroupId());
            }
            for (SAMProgramRecord sAMProgramRecord2 : list) {
                if (sAMProgramRecord2.getProgramGroupId().equals(sAMProgramRecord.getProgramGroupId()) || arrayList.contains(sAMProgramRecord2.getProgramGroupId())) continue;
                sAMProgramRecord.setPreviousProgramGroupId(sAMProgramRecord2.getProgramGroupId());
                break;
            }
        }
    }

    public static void makeReadUnmapped(SAMRecord sAMRecord) {
        if (sAMRecord.getReadNegativeStrandFlag()) {
            SAMRecordUtil.reverseComplement(sAMRecord);
            sAMRecord.setReadNegativeStrandFlag(false);
        }
        sAMRecord.setDuplicateReadFlag(false);
        sAMRecord.setReferenceIndex(-1);
        sAMRecord.setAlignmentStart(0);
        sAMRecord.setCigarString("*");
        sAMRecord.setMappingQuality(0);
        sAMRecord.setInferredInsertSize(0);
        sAMRecord.setNotPrimaryAlignmentFlag(false);
        sAMRecord.setProperPairFlag(false);
        sAMRecord.setReadUnmappedFlag(true);
    }

    public static boolean cigarMapsNoBasesToRef(Cigar cigar) {
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            if (!cigarElement.getOperator().consumesReadBases() || !cigarElement.getOperator().consumesReferenceBases()) continue;
            return false;
        }
        return true;
    }

    public static int compareMapqs(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (n == 0) {
            return -1;
        }
        if (n2 == 0) {
            return 1;
        }
        if (n == 255) {
            return -1;
        }
        if (n2 == 255) {
            return 1;
        }
        return n - n2;
    }

    public static int combineMapqs(int n, int n2) {
        n = n == 255 ? 1 : (n *= 100);
        n2 = n2 == 255 ? 1 : (n2 *= 100);
        return n + n2;
    }
}

