/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.seekablestream;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.sf.samtools.seekablestream.ISeekableStreamFactory;
import net.sf.samtools.seekablestream.SeekableFTPStream;
import net.sf.samtools.seekablestream.SeekableFileStream;
import net.sf.samtools.seekablestream.SeekableHTTPStream;
import net.sf.samtools.seekablestream.SeekableStream;

public class SeekableStreamFactory {
    private static final ISeekableStreamFactory DEFAULT_FACTORY;
    private static ISeekableStreamFactory currentFactory;

    private SeekableStreamFactory() {
    }

    public static void setInstance(ISeekableStreamFactory iSeekableStreamFactory) {
        currentFactory = iSeekableStreamFactory;
    }

    public static ISeekableStreamFactory getInstance() {
        return currentFactory;
    }

    public static boolean isFilePath(String string2) {
        return !string2.startsWith("http:") && !string2.startsWith("https:") && !string2.startsWith("ftp:");
    }

    static {
        currentFactory = DEFAULT_FACTORY = new DefaultSeekableStreamFactory();
    }

    private static class DefaultSeekableStreamFactory
    implements ISeekableStreamFactory {
        private DefaultSeekableStreamFactory() {
        }

        @Override
        public SeekableStream getStreamFor(URL uRL) throws IOException {
            return this.getStreamFor(uRL.toExternalForm());
        }

        @Override
        public SeekableStream getStreamFor(String string2) throws IOException {
            if (string2.startsWith("http:") || string2.startsWith("https:")) {
                URL uRL = new URL(string2);
                return new SeekableHTTPStream(uRL);
            }
            if (string2.startsWith("ftp:")) {
                return new SeekableFTPStream(new URL(string2));
            }
            return new SeekableFileStream(new File(string2));
        }
    }
}

