/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.samtools.SAMException;

public class DateParser {
    private static boolean check(StringTokenizer stringTokenizer, String string2) throws InvalidDateException {
        if (!stringTokenizer.hasMoreElements()) {
            return false;
        }
        if (stringTokenizer.nextToken().equals(string2)) {
            return true;
        }
        throw new InvalidDateException("Missing [" + string2 + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Calendar getCalendar(String string2) throws InvalidDateException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "-T:.+Z", true);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.clear();
        try {
            int n;
            int n2;
            if (!stringTokenizer.hasMoreTokens()) {
                return gregorianCalendar;
            }
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            gregorianCalendar.set(1, n3);
            if (!DateParser.check(stringTokenizer, "-") || !stringTokenizer.hasMoreTokens()) {
                return gregorianCalendar;
            }
            n3 = Integer.parseInt(stringTokenizer.nextToken()) - 1;
            gregorianCalendar.set(2, n3);
            if (!DateParser.check(stringTokenizer, "-") || !stringTokenizer.hasMoreTokens()) {
                return gregorianCalendar;
            }
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            gregorianCalendar.set(5, n3);
            if (!DateParser.check(stringTokenizer, "T") || !stringTokenizer.hasMoreTokens()) {
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                return gregorianCalendar;
            }
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            gregorianCalendar.set(11, n3);
            if (!DateParser.check(stringTokenizer, ":") || !stringTokenizer.hasMoreTokens()) {
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                return gregorianCalendar;
            }
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            gregorianCalendar.set(12, n3);
            if (!stringTokenizer.hasMoreTokens()) {
                return gregorianCalendar;
            }
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(":")) {
                if (!stringTokenizer.hasMoreTokens()) throw new InvalidDateException("No secondes specified");
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                gregorianCalendar.set(13, n2);
                if (!stringTokenizer.hasMoreTokens()) {
                    return gregorianCalendar;
                }
                string3 = stringTokenizer.nextToken();
                if (string3.equals(".")) {
                    String string4 = stringTokenizer.nextToken();
                    while (string4.length() < 3) {
                        string4 = string4 + "0";
                    }
                    string4 = string4.substring(0, 3);
                    n = Integer.parseInt(string4);
                    gregorianCalendar.set(14, n);
                    if (!stringTokenizer.hasMoreTokens()) {
                        return gregorianCalendar;
                    }
                    string3 = stringTokenizer.nextToken();
                } else {
                    gregorianCalendar.set(14, 0);
                }
            } else {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
            }
            if (string3.equals("Z")) return gregorianCalendar;
            if (!string3.equals("+") && !string3.equals("-")) {
                throw new InvalidDateException("only Z, + or - allowed");
            }
            n2 = string3.equals("+") ? 1 : 0;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new InvalidDateException("Missing hour field");
            }
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            n = 0;
            if (DateParser.check(stringTokenizer, ":") && stringTokenizer.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken());
            } else if (n4 >= 100) {
                n = n4 % 100;
                n4 /= 100;
            }
            if (n2 == 0) {
                ((Calendar)gregorianCalendar).add(10, n4);
                ((Calendar)gregorianCalendar).add(12, n);
                return gregorianCalendar;
            } else {
                ((Calendar)gregorianCalendar).add(10, -n4);
                ((Calendar)gregorianCalendar).add(12, -n);
            }
            return gregorianCalendar;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDateException("[" + numberFormatException.getMessage() + "] is not an integer");
        }
    }

    public static Date parse(String string2) throws InvalidDateException {
        Calendar calendar = DateParser.getCalendar(string2);
        return calendar.getTime();
    }

    private static String twoDigit(int n) {
        if (n >= 0 && n < 10) {
            return "0" + String.valueOf(n);
        }
        return String.valueOf(n);
    }

    public static String getIsoDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append("-");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(2) + 1));
        stringBuffer.append("-");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(5)));
        stringBuffer.append("T");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(11)));
        stringBuffer.append(":");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(12)));
        stringBuffer.append(":");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(13)));
        stringBuffer.append(".");
        stringBuffer.append(DateParser.twoDigit(gregorianCalendar.get(14) / 10));
        stringBuffer.append("Z");
        return stringBuffer.toString();
    }

    public static void test(String string2) {
        System.out.println("----------------------------------");
        try {
            Date date = DateParser.parse(string2);
            System.out.println(">> " + string2);
            System.out.println(">> " + date.toString() + " [" + date.getTime() + "]");
            System.out.println(">> " + DateParser.getIsoDate(date));
        }
        catch (InvalidDateException invalidDateException) {
            System.err.println(string2 + " is invalid");
            System.err.println(invalidDateException.getMessage());
        }
        System.out.println("----------------------------------");
    }

    public static void test(Date date) {
        String string2 = null;
        System.out.println("----------------------------------");
        try {
            System.out.println(">> " + date.toString() + " [" + date.getTime() + "]");
            string2 = DateParser.getIsoDate(date);
            System.out.println(">> " + string2);
            date = DateParser.parse(string2);
            System.out.println(">> " + date.toString() + " [" + date.getTime() + "]");
        }
        catch (InvalidDateException invalidDateException) {
            System.err.println(string2 + " is invalid");
            System.err.println(invalidDateException.getMessage());
        }
        System.out.println("----------------------------------");
    }

    public static void main(String[] stringArray) {
        DateParser.test("1997-07-16T19:20:30.45-02:00");
        DateParser.test("1997-07-16T19:20:30+01:00");
        DateParser.test("1997-07-16T19:20:30+01:00");
        DateParser.test("1997-07-16T19:20");
        DateParser.test("1997-07-16");
        DateParser.test("1997-07");
        DateParser.test("1997");
        DateParser.test(new Date());
    }

    public static class InvalidDateException
    extends SAMException {
        public InvalidDateException() {
        }

        public InvalidDateException(String string2) {
            super(string2);
        }

        public InvalidDateException(String string2, Throwable throwable) {
            super(string2, throwable);
        }

        public InvalidDateException(Throwable throwable) {
            super(throwable);
        }
    }
}

