/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.listener;

import java.io.File;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.listener.SimpleBigProjectLogger;
import org.apache.tools.ant.util.StringUtils;

public class BigProjectLogger
extends SimpleBigProjectLogger
implements SubBuildListener {
    private volatile boolean subBuildStartedRaised = false;
    private final Object subBuildLock = new Object();
    public static final String HEADER = "======================================================================";
    public static final String FOOTER = "======================================================================";

    protected String getBuildFailedMessage() {
        return super.getBuildFailedMessage() + " - at " + this.getTimestamp();
    }

    protected String getBuildSuccessfulMessage() {
        return super.getBuildSuccessfulMessage() + " - at " + this.getTimestamp();
    }

    public void targetStarted(BuildEvent event) {
        this.maybeRaiseSubBuildStarted(event);
        super.targetStarted(event);
    }

    public void taskStarted(BuildEvent event) {
        this.maybeRaiseSubBuildStarted(event);
        super.taskStarted(event);
    }

    public void buildFinished(BuildEvent event) {
        this.maybeRaiseSubBuildStarted(event);
        this.subBuildFinished(event);
        super.buildFinished(event);
    }

    public void messageLogged(BuildEvent event) {
        this.maybeRaiseSubBuildStarted(event);
        super.messageLogged(event);
    }

    public void subBuildStarted(BuildEvent event) {
        String name = this.extractNameOrDefault(event);
        Project project = event.getProject();
        File base = project == null ? null : project.getBaseDir();
        String path = base == null ? "With no base directory" : "In " + base.getAbsolutePath();
        this.printMessage(StringUtils.LINE_SEP + this.getHeader() + StringUtils.LINE_SEP + "Entering project " + name + StringUtils.LINE_SEP + path + StringUtils.LINE_SEP + this.getFooter(), this.out, event.getPriority());
    }

    protected String extractNameOrDefault(BuildEvent event) {
        String name = this.extractProjectName(event);
        name = name == null ? "" : '\"' + name + '\"';
        return name;
    }

    public void subBuildFinished(BuildEvent event) {
        String name = this.extractNameOrDefault(event);
        String failed2 = event.getException() != null ? "failing " : "";
        this.printMessage(StringUtils.LINE_SEP + this.getHeader() + StringUtils.LINE_SEP + "Exiting " + failed2 + "project " + name + StringUtils.LINE_SEP + this.getFooter(), this.out, event.getPriority());
    }

    protected String getHeader() {
        return "======================================================================";
    }

    protected String getFooter() {
        return "======================================================================";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRaiseSubBuildStarted(BuildEvent event) {
        if (!this.subBuildStartedRaised) {
            Object object = this.subBuildLock;
            synchronized (object) {
                if (!this.subBuildStartedRaised) {
                    this.subBuildStartedRaised = true;
                    this.subBuildStarted(event);
                }
            }
        }
    }
}

