/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.impl.TextUtils;

public class ReferenceFileParserException
extends PoolQException {
    private final int lineNumber;
    private final String line;

    public ReferenceFileParserException(String string2, int n, String[] stringArray) {
        super("Error parsing reference file (line " + n + "): " + string2);
        this.lineNumber = n;
        this.line = TextUtils.join(stringArray, ',');
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLine() {
        return this.line;
    }

    public static class EmptyReferenceFileException
    extends ReferenceFileParserException {
        public EmptyReferenceFileException(String string2, int n) {
            super(string2, n, new String[0]);
        }
    }

    public static class DuplicateConstructIdMappingException
    extends ReferenceFileParserException {
        public DuplicateConstructIdMappingException(String string2, int n, String[] stringArray) {
            super(string2, n, stringArray);
        }
    }

    public static class BadConstructIdException
    extends ReferenceFileParserException {
        public BadConstructIdException(String string2, int n, String[] stringArray) {
            super(string2, n, stringArray);
        }
    }

    public static class BadConstructException
    extends ReferenceFileParserException {
        public BadConstructException(String string2, int n, String[] stringArray) {
            super(string2, n, stringArray);
        }
    }

    public static class IncorrectNumberOfColumnsException
    extends ReferenceFileParserException {
        public IncorrectNumberOfColumnsException(String string2, int n, String[] stringArray) {
            super(string2, n, stringArray);
        }
    }
}

