/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class GeneralUtils {
    public static final boolean DEBUG_MODE_ENABLED = false;
    public static final double LOG10_P_OF_ZERO = -1000000.0;

    public static <T> String join(String string2, Collection<T> collection) {
        if (collection.isEmpty()) {
            return "";
        }
        Iterator<T> iterator2 = collection.iterator();
        T t = iterator2.next();
        if (!iterator2.hasNext()) {
            return t.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(t.toString());
        while (iterator2.hasNext()) {
            stringBuilder.append(string2);
            stringBuilder.append(iterator2.next().toString());
        }
        return stringBuilder.toString();
    }

    public static double[] normalizeFromLog10(double[] dArray) {
        return GeneralUtils.normalizeFromLog10(dArray, false);
    }

    public static double[] normalizeFromLog10(double[] dArray, boolean bl) {
        return GeneralUtils.normalizeFromLog10(dArray, bl, false);
    }

    public static double[] normalizeFromLog10(double[] dArray, boolean bl, boolean bl2) {
        int n;
        double d = GeneralUtils.arrayMax(dArray);
        if (bl2) {
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] - d;
            }
            return dArray;
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.pow(10.0, dArray[i] - d);
        }
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d2 += dArray2[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            double d3 = dArray2[n] / d2;
            if (bl && ((d3 = Math.log10(d3)) < -1000000.0 || Double.isInfinite(d3))) {
                d3 = dArray[n] - d;
            }
            dArray2[n] = d3;
        }
        return dArray2;
    }

    public static double arrayMax(double[] dArray) {
        return dArray[GeneralUtils.maxElementIndex(dArray, dArray.length)];
    }

    public static int maxElementIndex(double[] dArray) {
        return GeneralUtils.maxElementIndex(dArray, dArray.length);
    }

    public static int maxElementIndex(double[] dArray, int n) {
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException("Array cannot be null!");
        }
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            if (!(dArray[i] > dArray[n2])) continue;
            n2 = i;
        }
        return n2;
    }

    public static <T> List<T> cons(T t, List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(t);
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static <T> List<List<T>> makePermutations(List<T> list, int n, boolean bl) {
        ArrayList<List<T>> arrayList;
        block5: {
            arrayList = new ArrayList<List<T>>();
            if (n <= 0) break block5;
            if (n == 1) {
                for (T t : list) {
                    arrayList.add(Collections.singletonList(t));
                }
            } else {
                List<List<T>> list2 = GeneralUtils.makePermutations(list, n - 1, bl);
                for (List<T> list3 : list2) {
                    for (T t : list) {
                        if (!bl && list3.contains(t)) continue;
                        arrayList.add(GeneralUtils.cons(t, list3));
                    }
                }
            }
        }
        return arrayList;
    }

    public static byte compareDoubles(double d, double d2) {
        return GeneralUtils.compareDoubles(d, d2, 1.0E-6);
    }

    public static byte compareDoubles(double d, double d2, double d3) {
        if (Math.abs(d - d2) < d3) {
            return 0;
        }
        if (d > d2) {
            return -1;
        }
        return 1;
    }

    public static final <T> List<T> reverse(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>(list);
        Collections.reverse(arrayList);
        return arrayList;
    }
}

