/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.BaseLocalUtilizationTracker;
import com.sleepycat.je.cleaner.DbFileSummaryMap;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.utilint.DbLsn;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class RecoveryUtilizationTracker
extends BaseLocalUtilizationTracker {
    private final Map<Long, Long> fileSummaryLsns = new HashMap<Long, Long>();
    private final Map<DatabaseId, Long> databaseLsns = new HashMap<DatabaseId, Long>();

    public RecoveryUtilizationTracker(EnvironmentImpl env) {
        super(env, new HashMap<Object, DbFileSummaryMap>());
    }

    public void saveLastLoggedFileSummaryLN(long fileNum, long lsn) {
        this.fileSummaryLsns.put(fileNum, lsn);
    }

    public void saveLastLoggedMapLN(DatabaseId dbId, long lsn) {
        this.databaseLsns.put(dbId, lsn);
    }

    public void countNewLogEntry(long lsn, LogEntryType type, int size2, DatabaseId dbId) {
        this.countNew(lsn, dbId, type, size2);
    }

    public void countObsoleteUnconditional(long lsn, LogEntryType type, int size2, DatabaseId dbId, boolean countExact) {
        this.countObsolete(lsn, dbId, type, size2, true, true, countExact, false);
    }

    public boolean countObsoleteIfUncounted(long oldLsn, long newLsn, LogEntryType type, int size2, DatabaseId dbId, boolean countExact) {
        Long fileNum = DbLsn.getFileNumber(oldLsn);
        boolean fileUncounted = this.isFileUncounted(fileNum, newLsn);
        boolean dbUncounted = this.isDbUncounted(dbId, newLsn);
        this.countObsolete(oldLsn, dbId, type, size2, fileUncounted, dbUncounted, countExact, false);
        return fileUncounted;
    }

    public int fetchLNSize(int size2, long lsn) throws DatabaseException {
        if (size2 == 0 && this.env.getCleaner().getFetchObsoleteSize()) {
            try {
                LN ln = (LN)this.env.getLogManager().getEntry(lsn);
                size2 = ln.getLastLoggedSize();
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return size2;
    }

    boolean isFileUncounted(Long fileNum, long lsn) {
        long fsLsn = DbLsn.longToLsn(this.fileSummaryLsns.get(fileNum));
        int cmpFsLsnToNewLsn = fsLsn != -1L ? DbLsn.compareTo(fsLsn, lsn) : -1;
        return cmpFsLsnToNewLsn < 0;
    }

    private boolean isDbUncounted(DatabaseId dbId, long lsn) {
        long dbLsn = DbLsn.longToLsn(this.databaseLsns.get(dbId));
        int cmpDbLsnToLsn = dbLsn != -1L ? DbLsn.compareTo(dbLsn, lsn) : -1;
        return cmpDbLsnToLsn < 0;
    }

    public void resetFileInfo(long fileNum) {
        TrackedFileSummary trackedSummary = this.getTrackedFile(fileNum);
        if (trackedSummary != null) {
            trackedSummary.reset();
        }
    }

    public void resetDbInfo(DatabaseId dbId) {
        this.removeDbFileSummaries(dbId);
    }

    DatabaseImpl databaseKeyToDatabaseImpl(Object databaseKey) throws DatabaseException {
        DatabaseId dbId = (DatabaseId)databaseKey;
        return this.env.getDbTree().getDb(dbId);
    }

    void releaseDatabaseImpl(DatabaseImpl db) {
        this.env.getDbTree().releaseDb(db);
    }
}

