/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.CommitToken;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.utilint.PropUtil;
import java.util.concurrent.TimeUnit;

public class CommitPointConsistencyPolicy
implements ReplicaConsistencyPolicy {
    public static final String NAME = "CommitPointConsistencyPolicy";
    private final CommitToken commitToken;
    private final int timeout;

    public CommitPointConsistencyPolicy(CommitToken commitToken, long timeout, TimeUnit timeoutUnit) {
        if (commitToken == null) {
            throw new IllegalArgumentException("commitToken must not be null");
        }
        this.commitToken = commitToken;
        this.timeout = PropUtil.durationToMillis(timeout, timeoutUnit);
    }

    public String getName() {
        return NAME;
    }

    public void ensureConsistency(EnvironmentImpl envImpl) throws InterruptedException, ReplicaConsistencyException {
        RepImpl repImpl = (RepImpl)envImpl;
        if (!this.commitToken.getRepenvUUID().equals(repImpl.getRepNode().getUUID())) {
            throw new IllegalArgumentException("Replication environment mismatch. The UUID associated with the commit token is: " + this.commitToken.getRepenvUUID() + " but this replica environment has the UUID: " + repImpl.getRepNode().getUUID());
        }
        Replica replica = repImpl.getRepNode().replica();
        replica.getConsistencyTracker().awaitVLSN(this.commitToken.getVLSN(), this);
    }

    public CommitToken getCommitToken() {
        return this.commitToken;
    }

    public long getTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.timeout, unit);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.commitToken == null ? 0 : this.commitToken.hashCode());
        result2 = 31 * result2 + this.timeout;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitPointConsistencyPolicy)) {
            return false;
        }
        CommitPointConsistencyPolicy other = (CommitPointConsistencyPolicy)obj;
        if (this.commitToken == null ? other.commitToken != null : !this.commitToken.equals(other.commitToken)) {
            return false;
        }
        return this.timeout == other.timeout;
    }

    public String toString() {
        return this.getName() + " commitToken=" + this.commitToken;
    }
}

