/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Comparator;
import net.sf.picard.util.Interval;
import net.sf.samtools.SAMFileHeader;

class IntervalCoordinateComparator
implements Comparator<Interval> {
    private final SAMFileHeader header;

    IntervalCoordinateComparator(SAMFileHeader sAMFileHeader) {
        this.header = sAMFileHeader;
    }

    @Override
    public int compare(Interval interval, Interval interval2) {
        int n;
        int n2 = this.header.getSequenceIndex(interval.getSequence());
        int n3 = n2 - (n = this.header.getSequenceIndex(interval2.getSequence()));
        if (n3 == 0) {
            n3 = interval.getStart() - interval2.getStart();
        }
        if (n3 == 0) {
            n3 = interval.getEnd() - interval2.getEnd();
        }
        if (n3 == 0) {
            if (interval.isPositiveStrand() && interval2.isNegativeStrand()) {
                n3 = -1;
            } else if (interval.isNegativeStrand() && interval2.isPositiveStrand()) {
                n3 = 1;
            }
        }
        if (n3 == 0) {
            if (interval.getName() == null) {
                if (interval2.getName() == null) {
                    return 0;
                }
                return -1;
            }
            if (interval2.getName() == null) {
                return 1;
            }
            return interval.getName().compareTo(interval2.getName());
        }
        return n3;
    }
}

