/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

public class SolexaQualityConverter {
    public static final int SOLEXA_ADDEND = 64;
    public static final int PHRED_ADDEND = 33;
    private static SolexaQualityConverter singleton = null;
    private final byte[] phredScore = new byte[256];

    public static synchronized SolexaQualityConverter getSingleton() {
        if (singleton == null) {
            singleton = new SolexaQualityConverter();
        }
        return singleton;
    }

    private SolexaQualityConverter() {
        int n;
        for (n = 0; n < 64; ++n) {
            this.phredScore[n] = 0;
        }
        for (n = 64; n < this.phredScore.length; ++n) {
            this.phredScore[n] = this.convertSolexaQualityCharToPhredBinary(n);
        }
    }

    private byte convertSolexaQualityCharToPhredBinary(int n) {
        return (byte)Math.round(10.0 * Math.log10(1.0 + Math.pow(10.0, (double)(n - 64) / 10.0)));
    }

    public byte solexaCharToPhredBinary(byte by2) {
        return this.phredScore[by2];
    }

    public byte[] getSolexaToPhredConversionTable() {
        return this.phredScore;
    }

    public void convertSolexaQualityCharsToPhredBinary(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.phredScore[byArray[i]];
        }
    }

    public void convertSolexaQualityCharsToPhredChars(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(this.phredScore[byArray[i]] + 33 & 0xFF);
        }
    }

    public void convertSolexa_1_3_QualityCharsToPhredBinary(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = n++;
            byArray[n2] = (byte)(byArray[n2] - 64);
        }
    }

    public void convertSolexa_1_3_QualityCharsToPhredBinary(int n, int n2, byte[] byArray) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            int n5 = n4++;
            byArray[n5] = (byte)(byArray[n5] - 64);
        }
    }
}

