/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.FastGenotype;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;

@Invariant(value={"alleles != null"})
public final class GenotypeBuilder {
    private static final List<Allele> HAPLOID_NO_CALL = Arrays.asList(Allele.NO_CALL);
    private static final List<Allele> DIPLOID_NO_CALL = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);
    private String sampleName = null;
    private List<Allele> alleles = Collections.emptyList();
    private boolean isPhased = false;
    private int GQ = -1;
    private int DP = -1;
    private int[] AD = null;
    private int[] PL = null;
    private Map<String, Object> extendedAttributes = null;
    private String filters = null;
    private int initialAttributeMapSize = 5;
    private static final Map<String, Object> NO_ATTRIBUTES = Collections.unmodifiableMap(new HashMap(0));

    public static Genotype create(String string2, List<Allele> list) {
        return new GenotypeBuilder(string2, list).make();
    }

    public static Genotype create(String string2, List<Allele> list, Map<String, Object> map2) {
        return new GenotypeBuilder(string2, list).attributes(map2).make();
    }

    protected static Genotype create(String string2, List<Allele> list, double[] dArray) {
        return new GenotypeBuilder(string2, list).PL(dArray).make();
    }

    public static Genotype createMissing(String string2, int n) {
        GenotypeBuilder genotypeBuilder = new GenotypeBuilder(string2);
        switch (n) {
            case 1: {
                genotypeBuilder.alleles(HAPLOID_NO_CALL);
                break;
            }
            case 2: {
                genotypeBuilder.alleles(DIPLOID_NO_CALL);
                break;
            }
            default: {
                genotypeBuilder.alleles(Collections.nCopies(n, Allele.NO_CALL));
            }
        }
        return genotypeBuilder.make();
    }

    public GenotypeBuilder() {
    }

    public GenotypeBuilder(String string2) {
        this.name(string2);
    }

    public GenotypeBuilder(String string2, List<Allele> list) {
        this.name(string2);
        this.alleles(list);
    }

    public GenotypeBuilder(Genotype genotype) {
        this.copy(genotype);
    }

    public GenotypeBuilder copy(Genotype genotype) {
        this.name(genotype.getSampleName());
        this.alleles(genotype.getAlleles());
        this.phased(genotype.isPhased());
        this.GQ(genotype.getGQ());
        this.DP(genotype.getDP());
        this.AD(genotype.getAD());
        this.PL(genotype.getPL());
        this.filter(genotype.getFilters());
        this.attributes(genotype.getExtendedAttributes());
        return this;
    }

    public final void reset(boolean bl) {
        if (!bl) {
            this.sampleName = null;
        }
        this.alleles = Collections.emptyList();
        this.isPhased = false;
        this.GQ = -1;
        this.DP = -1;
        this.AD = null;
        this.PL = null;
        this.filters = null;
        this.extendedAttributes = null;
    }

    @Ensures(value={"result != null"})
    public Genotype make() {
        Map<String, Object> map2 = this.extendedAttributes == null ? NO_ATTRIBUTES : this.extendedAttributes;
        return new FastGenotype(this.sampleName, this.alleles, this.isPhased, this.GQ, this.DP, this.AD, this.PL, this.filters, map2);
    }

    @Requires(value={"sampleName != null"})
    @Ensures(value={"this.sampleName != null"})
    public GenotypeBuilder name(String string2) {
        this.sampleName = string2;
        return this;
    }

    @Ensures(value={"this.alleles != null"})
    public GenotypeBuilder alleles(List<Allele> list) {
        this.alleles = list == null ? Collections.emptyList() : list;
        return this;
    }

    public GenotypeBuilder phased(boolean bl) {
        this.isPhased = bl;
        return this;
    }

    @Requires(value={"GQ >= -1"})
    @Ensures(value={"this.GQ == GQ", "this.GQ >= -1"})
    public GenotypeBuilder GQ(int n) {
        this.GQ = n;
        return this;
    }

    @Deprecated
    public GenotypeBuilder log10PError(double d) {
        if (d == 1.0) {
            return this.GQ(-1);
        }
        return this.GQ((int)Math.round(d * -10.0));
    }

    public GenotypeBuilder noGQ() {
        this.GQ = -1;
        return this;
    }

    public GenotypeBuilder noAD() {
        this.AD = null;
        return this;
    }

    public GenotypeBuilder noDP() {
        this.DP = -1;
        return this;
    }

    public GenotypeBuilder noPL() {
        this.PL = null;
        return this;
    }

    @Requires(value={"DP >= -1"})
    @Ensures(value={"this.DP == DP"})
    public GenotypeBuilder DP(int n) {
        this.DP = n;
        return this;
    }

    @Requires(value={"AD == null || AD.length > 0"})
    @Ensures(value={"this.AD == AD"})
    public GenotypeBuilder AD(int[] nArray) {
        this.AD = nArray;
        return this;
    }

    @Requires(value={"PL == null || PL.length > 0"})
    @Ensures(value={"this.PL == PL"})
    public GenotypeBuilder PL(int[] nArray) {
        this.PL = nArray;
        return this;
    }

    @Requires(value={"PL == null || PL.length > 0"})
    @Ensures(value={"this.PL == PL"})
    public GenotypeBuilder PL(double[] dArray) {
        this.PL = GenotypeLikelihoods.fromLog10Likelihoods(dArray).getAsPLs();
        return this;
    }

    @Requires(value={"attributes != null"})
    @Ensures(value={"attributes.isEmpty() || extendedAttributes != null"})
    public GenotypeBuilder attributes(Map<String, Object> map2) {
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            this.attribute(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public GenotypeBuilder noAttributes() {
        this.extendedAttributes = null;
        return this;
    }

    @Requires(value={"key != null"})
    @Ensures(value={"extendedAttributes != null", "extendedAttributes.containsKey(key)"})
    public GenotypeBuilder attribute(String string2, Object object) {
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new HashMap<String, Object>(this.initialAttributeMapSize);
        }
        this.extendedAttributes.put(string2, object);
        return this;
    }

    @Requires(value={"filters != null"})
    public GenotypeBuilder filters(List<String> list) {
        if (list.isEmpty()) {
            return this.filter(null);
        }
        if (list.size() == 1) {
            return this.filter(list.get(0));
        }
        return this.filter(ParsingUtils.join(";", ParsingUtils.sortList(list)));
    }

    @Requires(value={"filters != null"})
    public GenotypeBuilder filters(String ... stringArray) {
        return this.filters(Arrays.asList(stringArray));
    }

    public GenotypeBuilder filter(String string2) {
        this.filters = "PASS".equals(string2) ? null : string2;
        return this;
    }

    public GenotypeBuilder unfiltered() {
        return this.filter(null);
    }

    public GenotypeBuilder maxAttributes(int n) {
        this.initialAttributeMapSize = n;
        return this;
    }
}

