/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMSequenceRecord;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;
import org.broadinstitute.variant.vcf.VCFSimpleHeaderLine;

public class VCFContigHeaderLine
extends VCFSimpleHeaderLine {
    final Integer contigIndex;

    public VCFContigHeaderLine(String string2, VCFHeaderVersion vCFHeaderVersion, String string3, int n) {
        super(string2, vCFHeaderVersion, string3, null);
        if (n < 0) {
            throw new TribbleException("The contig index is less than zero.");
        }
        this.contigIndex = n;
    }

    public VCFContigHeaderLine(Map<String, String> map2, int n) {
        super("contig", map2);
        if (n < 0) {
            throw new TribbleException("The contig index is less than zero.");
        }
        this.contigIndex = n;
    }

    VCFContigHeaderLine(final SAMSequenceRecord sAMSequenceRecord, final String string2) {
        super("contig", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("ID", sAMSequenceRecord.getSequenceName());
                this.put("length", Integer.toString(sAMSequenceRecord.getSequenceLength()));
                if (string2 != null) {
                    this.put("assembly", string2);
                }
            }
        });
        this.contigIndex = sAMSequenceRecord.getSequenceIndex();
    }

    public Integer getContigIndex() {
        return this.contigIndex;
    }

    public SAMSequenceRecord getSAMSequenceRecord() {
        String string2 = this.getGenericFieldValue("length");
        if (string2 == null) {
            throw new TribbleException("Contig " + this.getID() + " does not have a length field.");
        }
        SAMSequenceRecord sAMSequenceRecord = new SAMSequenceRecord(this.getID(), Integer.valueOf(string2));
        sAMSequenceRecord.setSequenceIndex(this.contigIndex);
        return sAMSequenceRecord;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof VCFContigHeaderLine) {
            return this.contigIndex.compareTo(((VCFContigHeaderLine)object).contigIndex);
        }
        return super.compareTo(object);
    }
}

