/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jmx;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseExistsException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEMBeanHelper {
    public static final String ATT_ENV_HOME = "environmentHome";
    public static final String ATT_OPEN = "isOpen";
    public static final String ATT_IS_READ_ONLY = "isReadOnly";
    public static final String ATT_IS_TRANSACTIONAL = "isTransactional";
    public static final String ATT_CACHE_SIZE = "cacheSize";
    public static final String ATT_CACHE_PERCENT = "cachePercent";
    public static final String ATT_LOCK_TIMEOUT = "lockTimeout";
    public static final String ATT_IS_SERIALIZABLE = "isSerializableIsolation";
    public static final String ATT_TXN_TIMEOUT = "transactionTimeout";
    public static final String ATT_SET_READ_ONLY = "openReadOnly";
    public static final String ATT_SET_TRANSACTIONAL = "openTransactional";
    public static final String ATT_SET_SERIALIZABLE = "openSerializableIsolation";
    private static final MBeanAttributeInfo[] COMMON_ATTR = new MBeanAttributeInfo[]{new MBeanAttributeInfo("environmentHome", "java.lang.String", "Environment home directory.", true, false, false), new MBeanAttributeInfo("isOpen", "java.lang.Boolean", "True if this environment is open.", true, false, true)};
    private static final MBeanAttributeInfo[] OPEN_ATTR = new MBeanAttributeInfo[]{new MBeanAttributeInfo("isReadOnly", "java.lang.Boolean", "True if this environment is read only.", true, false, true), new MBeanAttributeInfo("isTransactional", "java.lang.Boolean", "True if this environment supports transactions.", true, false, true), new MBeanAttributeInfo("cacheSize", "java.lang.Long", "Cache size, in bytes.", true, true, false), new MBeanAttributeInfo("cachePercent", "java.lang.Integer", "By default, cache size is (cachePercent * JVM maximum memory. To change the cache size using a percentage of the heap size, set the cache size to 0 and cachePercent to the desired percentage value.", true, true, false), new MBeanAttributeInfo("lockTimeout", "java.lang.Long", "Lock timeout, in microseconds.", true, false, false)};
    private static final MBeanAttributeInfo[] TRANSACTIONAL_ATTR = new MBeanAttributeInfo[]{new MBeanAttributeInfo("isSerializableIsolation", "java.lang.Boolean", "True if this environment provides Serializable (degree 3) isolation. The default is RepeatableRead isolation.", true, false, true), new MBeanAttributeInfo("transactionTimeout", "java.lang.Long", "Transaction timeout, in seconds. A value of 0 means there is no timeout.", true, false, false)};
    private static final MBeanAttributeInfo[] CREATE_ATTR = new MBeanAttributeInfo[]{new MBeanAttributeInfo("openReadOnly", "java.lang.Boolean", "True if this environment should be opened in readonly mode.", true, true, false), new MBeanAttributeInfo("openTransactional", "java.lang.Boolean", "True if this environment should be opened in transactional mode.", true, true, false), new MBeanAttributeInfo("openSerializableIsolation", "java.lang.Boolean", "True if this environment should be opened with serializableIsolation. The default is false.", true, true, false)};
    static final String OP_CLEAN = "cleanLog";
    static final String OP_EVICT = "evictMemory";
    static final String OP_CHECKPOINT = "checkpoint";
    static final String OP_SYNC = "sync";
    static final String OP_ENV_STAT = "getEnvironmentStats";
    static final String OP_TXN_STAT = "getTxnStats";
    static final String OP_DB_NAMES = "getDatabaseNames";
    static final String OP_DB_STAT = "getDatabaseStats";
    private static final MBeanOperationInfo OP_CLEAN_INFO = new MBeanOperationInfo("cleanLog", "Remove obsolete environment log files. Zero or more log files will be cleaned as necessary to bring the disk space utilization of the environment above the configured minimum utilization threshold as determined by the setting je.cleaner.minUtilization. Returns the number of files cleaned, that will be deleted at the next qualifying checkpoint.", new MBeanParameterInfo[0], "java.lang.Integer", 3);
    private static final MBeanOperationInfo OP_EVICT_INFO = new MBeanOperationInfo("evictMemory", "Reduce cache usage to the threshold determined by the setting je.evictor.useMemoryFloor. ", new MBeanParameterInfo[0], "void", 3);
    private static final MBeanParameterInfo[] checkpointParams = new MBeanParameterInfo[]{new MBeanParameterInfo("force", "java.lang.Boolean", "If true, force a checkpoint even if there has been no activity since the last checkpoint. Returns true if a checkpoint executed.")};
    private static final MBeanOperationInfo OP_CHECKPOINT_INFO = new MBeanOperationInfo("checkpoint", "Checkpoint the environment.", checkpointParams, "void", 3);
    private static final MBeanOperationInfo OP_SYNC_INFO = new MBeanOperationInfo("sync", "Flush the environment to stable storage.", new MBeanParameterInfo[0], "void", 3);
    private static final MBeanParameterInfo[] statParams = new MBeanParameterInfo[]{new MBeanParameterInfo("clear", "java.lang.Boolean", "If true, reset statistics after reading."), new MBeanParameterInfo("fast", "java.lang.Boolean", "If true, only return statistics which do not require expensive computation.")};
    private static final MBeanOperationInfo OP_ENV_STAT_INFO = new MBeanOperationInfo("getEnvironmentStats", "Get environment statistics.", statParams, "java.lang.String", 0);
    private static final MBeanOperationInfo OP_TXN_STAT_INFO = new MBeanOperationInfo("getTxnStats", "Get transactional statistics.", statParams, "java.lang.String", 0);
    private static final MBeanOperationInfo OP_DB_NAMES_INFO = new MBeanOperationInfo("getDatabaseNames", "Get the names of databases in the environment.", new MBeanParameterInfo[0], "java.util.ArrayList", 0);
    private static final MBeanParameterInfo[] dbStatParams = new MBeanParameterInfo[]{new MBeanParameterInfo("clear", "java.lang.Boolean", "If true, reset statistics after reading."), new MBeanParameterInfo("fast", "java.lang.Boolean", "If true, only return statistics which do not require expensive computation. Currently all database stats are not fast."), new MBeanParameterInfo("databaseName", "java.lang.String", "database name")};
    private static final MBeanOperationInfo OP_DB_STAT_INFO = new MBeanOperationInfo("getDatabaseStats", "Get database statistics.", dbStatParams, "java.lang.String", 0);
    private File environmentHome;
    private boolean canConfigure;
    private EnvironmentConfig openConfig;
    private boolean needReset;
    private boolean envWasOpen;

    public JEMBeanHelper(File environmentHome, boolean canConfigure) {
        if (environmentHome == null) {
            throw new IllegalArgumentException("Environment home cannot be null");
        }
        this.environmentHome = environmentHome;
        this.canConfigure = canConfigure;
        if (canConfigure) {
            this.openConfig = new EnvironmentConfig();
        }
    }

    public File getEnvironmentHome() {
        return this.environmentHome;
    }

    public EnvironmentConfig getEnvironmentOpenConfig() {
        return this.openConfig;
    }

    public Environment getEnvironmentIfOpen() {
        if (this.environmentHome == null) {
            return null;
        }
        return DbInternal.getEnvironmentShell(this.environmentHome);
    }

    public synchronized boolean getNeedReset() {
        return this.needReset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<MBeanAttributeInfo> getAttributeList(Environment targetEnv) {
        int i;
        this.setNeedReset(false);
        ArrayList<MBeanAttributeInfo> attrList = new ArrayList<MBeanAttributeInfo>();
        for (i = 0; i < COMMON_ATTR.length; ++i) {
            attrList.add(COMMON_ATTR[i]);
        }
        if (targetEnv == null) {
            if (!this.canConfigure) return attrList;
            for (i = 0; i < CREATE_ATTR.length; ++i) {
                attrList.add(CREATE_ATTR[i]);
            }
            return attrList;
        } else {
            for (i = 0; i < OPEN_ATTR.length; ++i) {
                attrList.add(OPEN_ATTR[i]);
            }
            try {
                EnvironmentConfig config = targetEnv.getConfig();
                if (!config.getTransactional()) return attrList;
                for (int i2 = 0; i2 < TRANSACTIONAL_ATTR.length; ++i2) {
                    attrList.add(TRANSACTIONAL_ATTR[i2]);
                }
                return attrList;
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        return attrList;
    }

    public Object getAttribute(Environment targetEnv, String attributeName) throws AttributeNotFoundException, MBeanException {
        if (attributeName == null) {
            throw new AttributeNotFoundException("Attribute name cannot be null");
        }
        try {
            if (attributeName.equals(ATT_ENV_HOME)) {
                return this.environmentHome.getCanonicalPath();
            }
            if (attributeName.equals(ATT_OPEN)) {
                boolean envIsOpen = targetEnv != null;
                this.resetIfOpenStateChanged(envIsOpen);
                return new Boolean(envIsOpen);
            }
            if (attributeName.equals(ATT_SET_READ_ONLY)) {
                return new Boolean(this.openConfig.getReadOnly());
            }
            if (attributeName.equals(ATT_SET_TRANSACTIONAL)) {
                return new Boolean(this.openConfig.getTransactional());
            }
            if (attributeName.equals(ATT_SET_SERIALIZABLE)) {
                return new Boolean(this.openConfig.getTxnSerializableIsolation());
            }
            if (targetEnv != null) {
                EnvironmentConfig config = targetEnv.getConfig();
                if (attributeName.equals(ATT_IS_READ_ONLY)) {
                    return new Boolean(config.getReadOnly());
                }
                if (attributeName.equals(ATT_IS_TRANSACTIONAL)) {
                    return new Boolean(config.getTransactional());
                }
                if (attributeName.equals(ATT_CACHE_SIZE)) {
                    return new Long(config.getCacheSize());
                }
                if (attributeName.equals(ATT_CACHE_PERCENT)) {
                    return new Integer(config.getCachePercent());
                }
                if (attributeName.equals(ATT_LOCK_TIMEOUT)) {
                    return new Long(config.getLockTimeout());
                }
                if (attributeName.equals(ATT_IS_SERIALIZABLE)) {
                    return new Boolean(config.getTxnSerializableIsolation());
                }
                if (attributeName.equals(ATT_TXN_TIMEOUT)) {
                    return new Long(config.getTxnTimeout());
                }
                throw new AttributeNotFoundException("attribute " + attributeName + " is not valid.");
            }
            return null;
        }
        catch (Exception e) {
            throw new MBeanException(e, e.getMessage());
        }
    }

    public void setAttribute(Environment targetEnv, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        block12: {
            if (attribute == null) {
                throw new AttributeNotFoundException("Attribute cannot be null");
            }
            String name = attribute.getName();
            Object value = attribute.getValue();
            if (name == null) {
                throw new AttributeNotFoundException("Attribute name cannot be null");
            }
            if (value == null) {
                throw new InvalidAttributeValueException("Attribute value for attribute " + name + " cannot be null");
            }
            try {
                if (name.equals(ATT_SET_READ_ONLY)) {
                    this.openConfig.setReadOnly((Boolean)value);
                    break block12;
                }
                if (name.equals(ATT_SET_TRANSACTIONAL)) {
                    this.openConfig.setTransactional((Boolean)value);
                    break block12;
                }
                if (name.equals(ATT_SET_SERIALIZABLE)) {
                    this.openConfig.setTxnSerializableIsolation((Boolean)value);
                    break block12;
                }
                if (targetEnv != null) {
                    EnvironmentMutableConfig config = targetEnv.getMutableConfig();
                    if (name.equals(ATT_CACHE_SIZE)) {
                        config.setCacheSize((Long)value);
                        targetEnv.setMutableConfig(config);
                        break block12;
                    }
                    if (name.equals(ATT_CACHE_PERCENT)) {
                        config.setCachePercent((Integer)value);
                        targetEnv.setMutableConfig(config);
                        break block12;
                    }
                    throw new AttributeNotFoundException("attribute " + name + " is not valid.");
                }
                throw new AttributeNotFoundException("attribute " + name + " is not valid.");
            }
            catch (NumberFormatException e) {
                throw new InvalidAttributeValueException("attribute name=" + name);
            }
            catch (DatabaseException e) {
                throw new InvalidAttributeValueException("attribute name=" + name + e.getMessage());
            }
        }
    }

    public List<MBeanOperationInfo> getOperationList(Environment targetEnv) {
        this.setNeedReset(false);
        ArrayList<MBeanOperationInfo> operationList = new ArrayList<MBeanOperationInfo>();
        if (targetEnv != null) {
            operationList.add(OP_CLEAN_INFO);
            operationList.add(OP_EVICT_INFO);
            operationList.add(OP_ENV_STAT_INFO);
            operationList.add(OP_DB_NAMES_INFO);
            operationList.add(OP_DB_STAT_INFO);
            boolean isTransactional = false;
            try {
                EnvironmentConfig config = targetEnv.getConfig();
                isTransactional = config.getTransactional();
            }
            catch (DatabaseException e) {
                return new ArrayList<MBeanOperationInfo>();
            }
            if (isTransactional) {
                operationList.add(OP_CHECKPOINT_INFO);
                operationList.add(OP_TXN_STAT_INFO);
            } else {
                operationList.add(OP_SYNC_INFO);
            }
        }
        return operationList;
    }

    public Object invoke(Environment targetEnv, String actionName, Object[] params, String[] signature) throws MBeanException {
        if (actionName == null) {
            throw new IllegalArgumentException("actionName cannot be null");
        }
        try {
            if (targetEnv != null) {
                if (actionName.equals(OP_CLEAN)) {
                    int numFiles = targetEnv.cleanLog();
                    return new Integer(numFiles);
                }
                if (actionName.equals(OP_EVICT)) {
                    targetEnv.evictMemory();
                    return null;
                }
                if (actionName.equals(OP_CHECKPOINT)) {
                    CheckpointConfig config = new CheckpointConfig();
                    if (params != null && params.length > 0) {
                        Boolean force = (Boolean)params[0];
                        config.setForce(force);
                    }
                    targetEnv.checkpoint(config);
                    return null;
                }
                if (actionName.equals(OP_SYNC)) {
                    targetEnv.sync();
                    return null;
                }
                if (actionName.equals(OP_ENV_STAT)) {
                    return targetEnv.getStats(this.getStatsConfig(params)).toString();
                }
                if (actionName.equals(OP_TXN_STAT)) {
                    return targetEnv.getTransactionStats(this.getStatsConfig(params)).toString();
                }
                if (actionName.equals(OP_DB_NAMES)) {
                    return targetEnv.getDatabaseNames();
                }
                if (actionName.equals(OP_DB_STAT)) {
                    DatabaseStats stats = this.getDatabaseStats(targetEnv, params);
                    return stats != null ? stats.toString() : null;
                }
            }
            return new IllegalArgumentException("actionName: " + actionName + " is not valid");
        }
        catch (Exception e) {
            throw new MBeanException(e, e.getMessage());
        }
    }

    private StatsConfig getStatsConfig(Object[] params) {
        StatsConfig statsConfig = new StatsConfig();
        if (params != null && params.length > 0 && params[0] != null) {
            Boolean clear2 = (Boolean)params[0];
            statsConfig.setClear(clear2);
        }
        if (params != null && params.length > 1 && params[1] != null) {
            Boolean fast = (Boolean)params[1];
            statsConfig.setFast(fast);
        }
        return statsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseStats getDatabaseStats(Environment targetEnv, Object[] params) throws IllegalArgumentException, DatabaseNotFoundException, DatabaseException {
        DatabaseStats databaseStats;
        block5: {
            if (params == null || params.length < 3) {
                return null;
            }
            String dbName = (String)params[2];
            Database db = null;
            try {
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setReadOnly(true);
                DbInternal.setUseExistingConfig(dbConfig, true);
                try {
                    db = targetEnv.openDatabase(null, dbName, dbConfig);
                }
                catch (DatabaseExistsException e) {
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                databaseStats = db.getStats(this.getStatsConfig(params));
                Object var8_8 = null;
                if (db == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_9 = null;
                    if (db == null) break block6;
                    db.close();
                }
                throw throwable;
            }
            db.close();
        }
        return databaseStats;
    }

    public MBeanNotificationInfo[] getNotificationInfo(Environment targetEnv) {
        return null;
    }

    private synchronized void setNeedReset(boolean reset2) {
        this.needReset = reset2;
    }

    private synchronized void resetIfOpenStateChanged(boolean isOpen) {
        if (isOpen != this.envWasOpen) {
            this.setNeedReset(true);
            this.envWasOpen = isOpen;
        }
    }
}

