/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMRecord;

public class ReadNameFilter
implements SamRecordFilter {
    private boolean includeReads = false;
    private Set<String> readNameFilterSet = new HashSet<String>();

    public ReadNameFilter(File file, boolean bl) {
        IoUtil.assertFileIsReadable(file);
        IoUtil.assertFileSizeNonZero(file);
        try {
            BufferedReader bufferedReader = IoUtil.openFileForBufferedReading(file);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().isEmpty()) continue;
                this.readNameFilterSet.add(string2.split("\\s+")[0]);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PicardException(iOException.getMessage(), iOException);
        }
        this.includeReads = bl;
    }

    public ReadNameFilter(Set<String> set, boolean bl) {
        this.readNameFilterSet = set;
        this.includeReads = bl;
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord) {
        return !(this.includeReads ? this.readNameFilterSet.contains(sAMRecord.getReadName()) : !this.readNameFilterSet.contains(sAMRecord.getReadName()));
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        return !(this.includeReads ? this.readNameFilterSet.contains(sAMRecord.getReadName()) && this.readNameFilterSet.contains(sAMRecord2.getReadName()) : !this.readNameFilterSet.contains(sAMRecord.getReadName()) && !this.readNameFilterSet.contains(sAMRecord2.getReadName()));
    }
}

