/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.picard.PicardException;
import net.sf.samtools.util.CollectionUtil;

public class BclQualityEvaluationStrategy {
    public static final int ILLUMINA_ALLEGED_MINIMUM_QUALITY = 2;
    private final int minimumRevisedQuality;
    private Map<Byte, AtomicInteger> qualityCountMap = Collections.synchronizedMap(new CollectionUtil.DefaultingMap<Byte, AtomicInteger>(new CollectionUtil.DefaultingMap.Factory<AtomicInteger, Byte>(){

        @Override
        public AtomicInteger make(Byte by2) {
            return new AtomicInteger(0);
        }
    }, true));

    public BclQualityEvaluationStrategy(int n) {
        this.minimumRevisedQuality = n;
    }

    private static byte generateRevisedQuality(byte by2) {
        return (byte)Math.max(by2, 1);
    }

    public byte reviseAndConditionallyLogQuality(byte by2) {
        byte by3 = BclQualityEvaluationStrategy.generateRevisedQuality(by2);
        if (by2 < 2) {
            this.qualityCountMap.get(by2).incrementAndGet();
        }
        return by3;
    }

    public void assertMinimumQualities() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<Byte, AtomicInteger> entry : this.qualityCountMap.entrySet()) {
            if (BclQualityEvaluationStrategy.generateRevisedQuality(entry.getKey()) >= this.minimumRevisedQuality) continue;
            linkedList.add(String.format("quality %s observed %s times", entry.getKey(), entry.getValue()));
        }
        if (!linkedList.isEmpty()) {
            throw new PicardException(String.format("Found BCL qualities that fell beneath minimum threshold of %s: %s.", this.minimumRevisedQuality, CollectionUtil.join(linkedList, "; ")));
        }
    }

    public Map<Byte, Integer> getPoorQualityFrequencies() {
        HashMap<Byte, Integer> hashMap = new HashMap<Byte, Integer>();
        for (Map.Entry<Byte, AtomicInteger> entry : this.qualityCountMap.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().intValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

