/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.picard.util.Log;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.TextCigarCodec;
import net.sf.samtools.util.CoordMath;

public class CigarUtil {
    private static final Log log = Log.getInstance(CigarUtil.class);

    public static List<CigarElement> softClipEndOfRead(int n, List<CigarElement> list) {
        int n2 = CoordMath.getLength(n, Cigar.getReadLength(list));
        LinkedList<CigarElement> linkedList = new LinkedList<CigarElement>();
        int n3 = 1;
        for (CigarElement cigarElement : list) {
            CigarOperator cigarOperator = cigarElement.getOperator();
            int n4 = cigarOperator.consumesReadBases() ? cigarElement.getLength() : 0;
            int n5 = n3 + n4 - 1;
            if (n5 < n - 1) {
                linkedList.add(cigarElement);
            } else if (n5 >= n - 1) {
                CigarUtil.elementStraddlesClippedRead(linkedList, cigarElement, n - 1 - (n3 - 1), n2);
                break;
            }
            n3 = n5 + 1;
        }
        return linkedList;
    }

    private static void elementStraddlesClippedRead(List<CigarElement> list, CigarElement cigarElement, int n, int n2) {
        CigarOperator cigarOperator = cigarElement.getOperator();
        int n3 = n2;
        if (cigarOperator.consumesReadBases()) {
            if (cigarOperator.consumesReferenceBases() & n > 0) {
                list.add(new CigarElement(n, cigarOperator));
            }
            if (!cigarOperator.consumesReferenceBases()) {
                n3 = n2 + n;
            }
        } else if (n != 0) {
            throw new SAMException("Unexpected non-0 relativeClippedPosition " + n);
        }
        list.add(new CigarElement(n3, CigarOperator.S));
    }

    public static void softClip3PrimeEndOfRead(SAMRecord sAMRecord, int n) {
        int n2;
        Cigar cigar = sAMRecord.getCigar();
        boolean bl = sAMRecord.getReadNegativeStrandFlag();
        List<CigarElement> list = cigar.getCigarElements();
        if (!CigarUtil.isValidCigar(sAMRecord, cigar, true)) {
            return;
        }
        if (bl) {
            list = new ArrayList<CigarElement>(list);
            Collections.reverse(list);
        }
        List<CigarElement> list2 = CigarUtil.softClipEndOfRead(n, list);
        if (bl) {
            Collections.reverse(list2);
        }
        Cigar cigar2 = new Cigar(list2);
        if (bl) {
            int n3;
            n2 = cigar.getReferenceLength();
            int n4 = n2 - (n3 = cigar2.getReferenceLength());
            if (n4 > 0) {
                sAMRecord.setAlignmentStart(sAMRecord.getAlignmentStart() + n4);
            } else if (n4 < 0) {
                throw new SAMException("The clipped length " + n3 + " is longer than the old unclipped length " + n2);
            }
        }
        sAMRecord.setCigar(cigar2);
        n2 = 0;
        for (CigarElement cigarElement : cigar2.getCigarElements()) {
            CigarOperator cigarOperator = cigarElement.getOperator();
            if (!cigarOperator.consumesReferenceBases() || !cigarOperator.consumesReadBases()) continue;
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            sAMRecord.setReadUnmappedFlag(true);
            sAMRecord.setCigarString("*");
            sAMRecord.setReferenceIndex(-1);
            sAMRecord.setAlignmentStart(0);
            sAMRecord.setMappingQuality(0);
            sAMRecord.setInferredInsertSize(0);
        } else if (!CigarUtil.isValidCigar(sAMRecord, cigar2, false)) {
            throw new IllegalStateException("Invalid new Cigar: " + cigar2 + " (" + list + ") for " + sAMRecord.getReadName());
        }
    }

    private static boolean isValidCigar(SAMRecord sAMRecord, Cigar cigar, boolean bl) {
        List<SAMValidationError> list;
        if (cigar == null || cigar.getCigarElements() == null || cigar.getCigarElements().size() == 0) {
            if (bl) {
                if (!sAMRecord.getReadUnmappedFlag()) {
                    log.warn("Cigar is empty for read " + sAMRecord);
                }
            } else {
                log.error("Empty new cigar");
            }
            return false;
        }
        if (sAMRecord.getReadUnmappedFlag()) {
            log.info("Unmapped read with cigar: " + sAMRecord.getReadName() + " (" + sAMRecord.getCigarString() + "/" + cigar.toString() + ")");
        }
        if ((list = cigar.isValid(sAMRecord.getReadName(), -1L)) != null && list.size() != 0) {
            log.error("Invalid cigar for read " + sAMRecord + (bl ? " " : " for new cigar with clipped adapter ") + " (" + sAMRecord.getCigarString() + "/" + cigar.toString() + ") " + list);
            return false;
        }
        if (sAMRecord.getReadLength() != cigar.getReadLength()) {
            log.error(sAMRecord.getReadLength() + " read length does not = cigar length " + cigar.getReferenceLength() + (bl ? " oldCigar " : " ") + sAMRecord + " cigar:" + cigar);
            return false;
        }
        return true;
    }

    public static Cigar addSoftClippedBasesToEndsOfCigar(Cigar cigar, boolean bl, int n, int n2) {
        int n3;
        ArrayList<CigarElement> arrayList = new ArrayList<CigarElement>(cigar.getCigarElements());
        if (bl) {
            Collections.reverse(arrayList);
        }
        if (n > 0) {
            n3 = arrayList.size() - 1;
            int n4 = n;
            if (((CigarElement)arrayList.get(n3)).getOperator() == CigarOperator.SOFT_CLIP) {
                CigarElement cigarElement = (CigarElement)arrayList.remove(n3);
                n4 += cigarElement.getLength();
            }
            arrayList.add(new CigarElement(n4, CigarOperator.SOFT_CLIP));
        }
        if (n2 > 0) {
            n3 = n2;
            if (((CigarElement)arrayList.get(0)).getOperator() == CigarOperator.SOFT_CLIP) {
                CigarElement cigarElement = (CigarElement)arrayList.remove(0);
                n3 += cigarElement.getLength();
            }
            arrayList.add(0, new CigarElement(n3, CigarOperator.SOFT_CLIP));
        }
        if (bl) {
            Collections.reverse(arrayList);
        }
        return new Cigar(arrayList);
    }

    public static char[] cigarArrayFromElements(List<CigarElement> list) {
        int n = 0;
        int n2 = 0;
        for (CigarElement object : list) {
            n2 += object.getLength();
        }
        Object object = new char[n2];
        for (CigarElement cigarElement : list) {
            for (int i = 0; i < cigarElement.getLength(); ++i) {
                CigarOperator cigarOperator = cigarElement.getOperator();
                object[i + n] = (char)CigarOperator.enumToCharacter(cigarOperator);
            }
            n += cigarElement.getLength();
        }
        return object;
    }

    public static char[] cigarArrayFromString(String string2) {
        return CigarUtil.cigarArrayFromElements(TextCigarCodec.getSingleton().decode(string2).getCigarElements());
    }

    public static String cigarStringFromArray(char[] cArray) {
        String string2 = "";
        int n = cArray.length;
        char c = '\u0000';
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == c) {
                ++n2;
                continue;
            }
            if (cArray[i] == '-') continue;
            if (c != '\u0000') {
                string2 = string2 + Integer.toString(n2) + Character.toString(c);
            }
            n2 = 1;
            c = cArray[i];
        }
        return string2 + Integer.toString(n2) + Character.toString(c);
    }
}

