/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.nio.ByteBuffer;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;

class BinaryCigarCodec {
    private static final BinaryCigarCodec singleton = new BinaryCigarCodec();

    BinaryCigarCodec() {
    }

    static BinaryCigarCodec getSingleton() {
        return singleton;
    }

    int[] encode(Cigar cigar) {
        if (cigar.numCigarElements() == 0) {
            return new int[0];
        }
        int[] nArray = new int[cigar.numCigarElements()];
        int n = 0;
        for (int i = 0; i < cigar.numCigarElements(); ++i) {
            CigarElement cigarElement = cigar.getCigarElement(i);
            int n2 = CigarOperator.enumToBinary(cigarElement.getOperator());
            nArray[n++] = cigarElement.getLength() << 4 | n2;
        }
        return nArray;
    }

    Cigar decode(ByteBuffer byteBuffer) {
        Cigar cigar = new Cigar();
        while (byteBuffer.hasRemaining()) {
            int n = byteBuffer.getInt();
            cigar.add(BinaryCigarCodec.binaryCigarToCigarElement(n));
        }
        return cigar;
    }

    Cigar decode(int[] nArray) {
        Cigar cigar = new Cigar();
        for (int n : nArray) {
            cigar.add(BinaryCigarCodec.binaryCigarToCigarElement(n));
        }
        return cigar;
    }

    private static CigarElement binaryCigarToCigarElement(int n) {
        int n2 = n & 0xF;
        int n3 = n >> 4;
        return new CigarElement(n3, CigarOperator.binaryToEnum(n2));
    }
}

