/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.extension.LibraryDisplayer;
import org.apache.tools.ant.types.FileSet;

public class JarLibDisplayTask
extends Task {
    private File libraryFile;
    private final Vector libraryFileSets = new Vector();

    public void setFile(File file) {
        this.libraryFile = file;
    }

    public void addFileset(FileSet fileSet) {
        this.libraryFileSets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        this.validate();
        LibraryDisplayer displayer = new LibraryDisplayer();
        if (!this.libraryFileSets.isEmpty()) {
            Iterator iterator2 = this.libraryFileSets.iterator();
            while (iterator2.hasNext()) {
                FileSet fileSet = (FileSet)iterator2.next();
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                File basedir = scanner.getBasedir();
                String[] files = scanner.getIncludedFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file = new File(basedir, files[i]);
                    displayer.displayLibrary(file);
                }
            }
        } else {
            displayer.displayLibrary(this.libraryFile);
        }
    }

    private void validate() throws BuildException {
        if (null == this.libraryFile && this.libraryFileSets.isEmpty()) {
            String message = "File attribute not specified.";
            throw new BuildException("File attribute not specified.");
        }
        if (null != this.libraryFile && !this.libraryFile.exists()) {
            String message = "File '" + this.libraryFile + "' does not exist.";
            throw new BuildException(message);
        }
        if (null != this.libraryFile && !this.libraryFile.isFile()) {
            String message = "'" + this.libraryFile + "' is not a file.";
            throw new BuildException(message);
        }
    }
}

