/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TextUtils {
    private TextUtils() {
    }

    public static String buildEnglishLanguageList(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 2) {
            return TextUtils.join(list, " and ");
        }
        return TextUtils.join(Arrays.asList(TextUtils.join(list.subList(0, list.size() - 2), ", "), TextUtils.join(list.subList(list.size() - 2, list.size()), " and ")), ", ");
    }

    public static String join(Iterable<?> iterable, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator2 = iterable.iterator();
        if (iterator2.hasNext()) {
            while (true) {
                stringBuilder.append(iterator2.next().toString());
                if (!iterator2.hasNext()) break;
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    public static String join(Iterable<?> iterable, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator2 = iterable.iterator();
        if (iterator2.hasNext()) {
            while (true) {
                stringBuilder.append(iterator2.next().toString());
                if (!iterator2.hasNext()) break;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    public static <T> String join(T[] TArray, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < TArray.length - 1; ++i) {
            stringBuilder.append(TArray[i]).append(c);
        }
        if (TArray.length > 0) {
            stringBuilder.append(TArray[TArray.length - 1]);
        }
        return stringBuilder.toString();
    }
}

