/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.InputStream;
import java.util.Iterator;
import org.broadinstitute.rnai.poolq.api.PoolQException;
import org.broadinstitute.rnai.poolq.impl.ReadOnlyIterator;
import org.broadinstitute.rnai.poolq.impl.fileparser.FastQIterator;
import org.broadinstitute.rnai.poolq.impl.fileparser.FastQRecord;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileInfo;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileIteratorFactory;
import org.broadinstitute.rnai.poolq.impl.fileparser.UncoordinatedFilesException;
import org.broadinstitute.rnai.poolq.impl.reads.MultiplexedReadInput;
import org.broadinstitute.rnai.poolq.impl.reads.Read;
import org.broadinstitute.rnai.poolq.impl.reads.ReadImpl;
import org.broadinstitute.rnai.poolq.impl.reads.ReadProcessor;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u001f\taR*\u001e7uSBdW\r_3e%\u0016\fGm\u001d$jY\u0016LE/\u001a:bE2,'BA\u0002\u0005\u0003)1\u0017\u000e\\3qCJ\u001cXM\u001d\u0006\u0003\u000b\u0019\tA![7qY*\u0011q\u0001C\u0001\u0006a>|G.\u001d\u0006\u0003\u0013)\tAA\u001d8bS*\u00111\u0002D\u0001\u000fEJ|\u0017\rZ5ogRLG/\u001e;f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u00111A\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000fE\u0002\u00123mI!A\u0007\n\u0003\u0011%#XM]1cY\u0016\u0004\"\u0001H\u0010\u000e\u0003uQ!A\b\u0003\u0002\u000bI,\u0017\rZ:\n\u0005\u0001j\"\u0001\u0002*fC\u0012D\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\u000ee\u0016\fG\r\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005q!\u0013BA\u0013\u001e\u00055\u0011V-\u00193Qe>\u001cWm]:pe\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\ftC6\u0004H.\u001a\"be\u000e|G-\u001a*fC\u0012\u001ch)\u001b7f!\tIsF\u0004\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3&\u0001\u0004Qe\u0016$WMZ\u0005\u0003aE\u0012aa\u0015;sS:<'B\u0001\u0018,\u0011!\u0019\u0004A!A!\u0002\u0013A\u0013!G2p]N$(/^2u\u0005\u0006\u00148m\u001c3f%\u0016\fGm\u001d$jY\u0016DQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtD\u0003B\u001c:um\u0002\"\u0001\u000f\u0001\u000e\u0003\tAQA\t\u001bA\u0002\rBQa\n\u001bA\u0002!BQa\r\u001bA\u0002!BQ!\u0010\u0001\u0005By\n\u0001\"\u001b;fe\u0006$xN\u001d\u000b\u0002\u007fA\u0019\u0001iQ\u000e\u000e\u0003\u0005S!A\u0011\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003\t\u0006\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u0007\r\u0002\u0001K\u0011B$\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0003\u0011:\u0003\"!\u0013'\u000e\u0003)S!a\u0013\u000b\u0002\u0005%|\u0017BA'K\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000b=+\u0005\u0019\u0001\u0015\u0002\u0011\u0019LG.\u001a(b[\u0016\u0004")
public class MultiplexedReadsFileIterable
implements Iterable<Read> {
    public final ReadProcessor org$broadinstitute$rnai$poolq$impl$fileparser$MultiplexedReadsFileIterable$$readProcessor;
    private final String sampleBarcodeReadsFile;
    private final String constructBarcodeReadsFile;

    @Override
    public Iterator<Read> iterator() {
        FastQIterator sampleIterator = new FastQIterator(this.inputStream(this.sampleBarcodeReadsFile));
        FastQIterator constructIterator = new FastQIterator(this.inputStream(this.constructBarcodeReadsFile));
        return new ReadOnlyIterator<Read>(this, sampleIterator, constructIterator){
            private final /* synthetic */ MultiplexedReadsFileIterable $outer;
            private final FastQIterator sampleIterator$1;
            private final FastQIterator constructIterator$1;

            public Read next() {
                FastQRecord constructRead = this.constructIterator$1.next();
                FastQRecord demultiplexingRead = this.sampleIterator$1.next();
                String string2 = constructRead.id();
                String string3 = demultiplexingRead.id();
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return new ReadImpl(this.$outer.org$broadinstitute$rnai$poolq$impl$fileparser$MultiplexedReadsFileIterable$$readProcessor, new MultiplexedReadInput(constructRead.seq(), demultiplexingRead.seq()));
                }
                throw new UncoordinatedFilesException("Read IDs for sample barcodes file do not match IDs for construct barcodes file");
            }

            public boolean hasNext() {
                return this.sampleIterator$1.hasNext() && this.constructIterator$1.hasNext();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sampleIterator$1 = sampleIterator$1;
                this.constructIterator$1 = constructIterator$1;
            }
        };
    }

    private InputStream inputStream(String fileName) {
        ReadsFileInfo fileInfo = ReadsFileInfo.forName(fileName);
        return ReadsFileIteratorFactory.inputStreamFor(fileName, fileInfo);
    }

    public MultiplexedReadsFileIterable(ReadProcessor readProcessor, String sampleBarcodeReadsFile, String constructBarcodeReadsFile) {
        this.org$broadinstitute$rnai$poolq$impl$fileparser$MultiplexedReadsFileIterable$$readProcessor = readProcessor;
        this.sampleBarcodeReadsFile = sampleBarcodeReadsFile;
        this.constructBarcodeReadsFile = constructBarcodeReadsFile;
        if (sampleBarcodeReadsFile == null) {
            throw new PoolQException("Sample barcode reads file must be provided");
        }
        if (constructBarcodeReadsFile == null) {
            throw new PoolQException("Construct barcode reads file must be provided");
        }
    }
}

