/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.rnai.poolq.api.QualityReportData;
import org.broadinstitute.rnai.poolq.impl.filewriter.LogNormalizer;

public class QualityReportFileWriter {
    private static final DecimalFormat FORMAT_THOUSANDTHS = new DecimalFormat("0.000");
    private static final DecimalFormat FORMAT_HUNDREDTHS = new DecimalFormat("0.00");
    public static final String TOTAL_NUMBER_OF_READS_PREFIX = "Total reads:\t\t\t";
    public static final String TOTAL_NUMBER_OF_MATCHING_READS_PREFIX = "Matching reads:\t\t\t";
    public static final String TOTAL_NUMBER_OF_SINGLE_BASE_MISMATCH_READS_PREFIX = "1-Base mismatch reads:\t\t\t";
    public static final String READS_WITH_NO_CONSTRUCT_BARCODE_PREFIX = "Reads with no construct barcode:\t\t\t";
    public static final String MAX_CONSTRUCT_BARCODE_INDEX_PREFIX = "Max construct barcode index:\t\t\t";
    public static final String MIN_CONSTRUCT_BARCODE_INDEX_PREFIX = "Min construct barcode index:\t\t\t";
    public static final String AVERAGE_CONSTRUCT_BARCODE_INDEX_PREFIX = "Avg construct barcode index:\t\t\t";
    public static final String PERCENTAGE_MATCHING_READS_WITH_BARCODES_PREFIX = "Overall % Match: (Construct+Sample Barcode)/total reads:\t\t\t";
    public static final String AVERAGE_NON_SAMPLE_BARCODE_COUNTS_PREFIX = "Avg. counts for unknown sample barcodes:\t\t\t";
    public static final String NORMALIZED_AVERAGE_NON_SAMPLE_BARCODE_COUNTS_PREFIX = "Normalized avg. unknown sample barcodes:\t\t\t";
    public static final String BARCODES_WITH_ASSOCIATED_CONDITIONS_HEADER = "Read counts for sample barcodes with associated conditions:";
    public static final String BARCODES_WITH_ASSOCIATED_CONDITIONS_COLS = "Barcode\tCondition\tMatched (Construct+Sample Barcode)\tMatched Sample Barcode\t%Match\tNormalized Match";
    public static final String BARCODES_WITHOUT_ASSOCIATED_CONDITIONS_HEADER = "Read counts for sample barcodes without associated conditions:";
    public static final String CONSTRUCTS_MATCHING_MULTIPLE_IDS_HEADER = "Construct barcodes matching multiple construct IDs:";
    public static final String NOT_APPLICABLE = "N/A";
    private final LogNormalizer normalizer = new LogNormalizer();

    public void writeQualityReportFile(QualityReportData qualityReportData, OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.writeReadCounts(qualityReportData, printWriter);
        printWriter.println();
        this.writeDerivedMatchStatistics(qualityReportData, printWriter);
        printWriter.println();
        this.writeConstructBarcodeStatistics(qualityReportData, printWriter);
        printWriter.println();
        this.writeCountsForBarcodesWithConditions(qualityReportData, printWriter);
        printWriter.println();
        this.writeCountsForBarcodesWithoutConditions(qualityReportData, printWriter);
        if (!qualityReportData.getTruncatedConstructBarcodeToCollidingConstructIdsMap().isEmpty()) {
            printWriter.println();
            this.writeConstructsMatchingMultipleConstructIds(qualityReportData, printWriter);
        }
        printWriter.close();
    }

    private void writeReadCounts(QualityReportData qualityReportData, PrintWriter printWriter) {
        printWriter.print(TOTAL_NUMBER_OF_READS_PREFIX);
        printWriter.println(qualityReportData.getNumberOfReads());
        printWriter.print(TOTAL_NUMBER_OF_MATCHING_READS_PREFIX);
        printWriter.println(qualityReportData.getNumberOfMatchingReads());
        printWriter.print(TOTAL_NUMBER_OF_SINGLE_BASE_MISMATCH_READS_PREFIX);
        printWriter.println(qualityReportData.getNumberOfSingleBaseMismatchReads());
    }

    private void writeConstructBarcodeStatistics(QualityReportData qualityReportData, PrintWriter printWriter) {
        if (qualityReportData.findConstructBarcodesByPrefix()) {
            printWriter.print(READS_WITH_NO_CONSTRUCT_BARCODE_PREFIX);
            printWriter.println(qualityReportData.getNumberOfReadsWithNoConstructBarcode());
            printWriter.print(MAX_CONSTRUCT_BARCODE_INDEX_PREFIX);
            printWriter.println(qualityReportData.maxConstructBarcodeIndex());
            printWriter.print(MIN_CONSTRUCT_BARCODE_INDEX_PREFIX);
            printWriter.println(qualityReportData.minConstructBarcodeIndex());
            printWriter.print(AVERAGE_CONSTRUCT_BARCODE_INDEX_PREFIX);
            printWriter.println(qualityReportData.meanConstructBarcodeIndex());
        } else {
            printWriter.print(READS_WITH_NO_CONSTRUCT_BARCODE_PREFIX);
            printWriter.println(NOT_APPLICABLE);
            printWriter.print(MAX_CONSTRUCT_BARCODE_INDEX_PREFIX);
            printWriter.println(NOT_APPLICABLE);
            printWriter.print(MIN_CONSTRUCT_BARCODE_INDEX_PREFIX);
            printWriter.println(NOT_APPLICABLE);
            printWriter.print(AVERAGE_CONSTRUCT_BARCODE_INDEX_PREFIX);
            printWriter.println(NOT_APPLICABLE);
        }
    }

    private void writeDerivedMatchStatistics(QualityReportData qualityReportData, PrintWriter printWriter) {
        long l;
        double d;
        printWriter.print(PERCENTAGE_MATCHING_READS_WITH_BARCODES_PREFIX);
        long l2 = qualityReportData.getNumberOfReads();
        if (l2 == 0L) {
            d = 0.0;
        } else {
            l = 0L;
            for (Map.Entry<String, String> entry : qualityReportData.getBarcodeToConditionMap().entrySet()) {
                String string2 = entry.getKey();
                l += (long)qualityReportData.getMatchingConstructReadCountForBarcode(string2).intValue();
            }
            d = (double)l / (double)l2;
        }
        printWriter.println(this.percentOf(d));
        printWriter.print(AVERAGE_NON_SAMPLE_BARCODE_COUNTS_PREFIX);
        l = (long)Math.pow(4.0, qualityReportData.getBarcodeLength()) - (long)qualityReportData.getBarcodeToConditionMap().keySet().size();
        long l3 = 0L;
        for (String string3 : qualityReportData.getBarcodesWithNonZeroReadCounts()) {
            if (this.barcodeIsMappedToCondition(qualityReportData, string3)) continue;
            l3 += (long)qualityReportData.getReadCountForBarcode(string3).intValue();
        }
        double d2 = l == 0L ? 0.0 : (double)l3 / (double)l;
        printWriter.println(this.decimalOf(d2));
        printWriter.print(NORMALIZED_AVERAGE_NON_SAMPLE_BARCODE_COUNTS_PREFIX);
        printWriter.println(this.decimalOf(this.normalizer.normalize(d2, qualityReportData.getNumberOfReads())));
    }

    private void writeCountsForBarcodesWithConditions(QualityReportData qualityReportData, PrintWriter printWriter) {
        printWriter.println(BARCODES_WITH_ASSOCIATED_CONDITIONS_HEADER);
        printWriter.println(BARCODES_WITH_ASSOCIATED_CONDITIONS_COLS);
        Map<String, String> map2 = qualityReportData.getBarcodeToConditionMap();
        for (String string2 : map2.keySet()) {
            Integer n = qualityReportData.getReadCountForBarcode(string2);
            assert (n != null);
            Integer n2 = qualityReportData.getMatchingConstructReadCountForBarcode(string2);
            Double d = (double)n.intValue() == 0.0 ? 0.0 : (double)n2.intValue() / (double)n.intValue();
            printWriter.append(string2);
            printWriter.append('\t');
            printWriter.append(map2.get(string2));
            printWriter.append('\t');
            printWriter.append(n2.toString());
            printWriter.append('\t');
            printWriter.append(n.toString());
            printWriter.append('\t');
            printWriter.append(this.percentOf(d));
            printWriter.append('\t');
            printWriter.append(this.decimalOf(this.normalizer.normalize(n2, qualityReportData.getNumberOfReads())));
            printWriter.println();
        }
    }

    private void writeCountsForBarcodesWithoutConditions(QualityReportData qualityReportData, PrintWriter printWriter) {
        printWriter.println(BARCODES_WITHOUT_ASSOCIATED_CONDITIONS_HEADER);
        TreeSet<String> treeSet = new TreeSet<String>(qualityReportData.getBarcodesWithNonZeroReadCounts());
        treeSet.removeAll(qualityReportData.getBarcodeToConditionMap().keySet());
        for (String string2 : treeSet) {
            Integer n = qualityReportData.getReadCountForBarcode(string2);
            printWriter.append(string2);
            printWriter.append('\t');
            printWriter.append(n.toString());
            printWriter.println();
        }
    }

    private boolean barcodeIsMappedToCondition(QualityReportData qualityReportData, String string2) {
        return qualityReportData.getBarcodeToConditionMap().containsKey(string2);
    }

    private void writeConstructsMatchingMultipleConstructIds(QualityReportData qualityReportData, PrintWriter printWriter) {
        printWriter.println(CONSTRUCTS_MATCHING_MULTIPLE_IDS_HEADER);
        Map<String, Set<String>> map2 = qualityReportData.getTruncatedConstructBarcodeToCollidingConstructIdsMap();
        for (String string2 : map2.keySet()) {
            printWriter.append(string2);
            printWriter.append(":");
            for (String string3 : map2.get(string2)) {
                printWriter.append("\t");
                printWriter.append(string3);
            }
            printWriter.println();
        }
    }

    String decimalOf(double d) {
        return FORMAT_THOUSANDTHS.format(d);
    }

    String percentOf(double d) {
        DecimalFormat decimalFormat = FORMAT_HUNDREDTHS;
        return decimalFormat.format(100.0 * d);
    }
}

