/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.reads;

import org.broadinstitute.rnai.poolq.api.ReadTooShortException;
import org.broadinstitute.rnai.poolq.impl.reads.ReadInput;
import org.broadinstitute.rnai.poolq.impl.reads.ReadProcessor;

public class FixedReadProcessor
implements ReadProcessor {
    private final int sampleBarcodeStartIndex;
    private final int sampleBarcodeLength;
    private final int constructBarcodeStartIndex;
    private final int minSampleReadLength;
    private final int minConstructReadLength;
    private final int constructBarcodeLength;

    public FixedReadProcessor(int n, int n2, int n3, int n4) {
        this.sampleBarcodeStartIndex = n;
        this.sampleBarcodeLength = n2;
        this.constructBarcodeStartIndex = n3;
        this.constructBarcodeLength = n4;
        this.minConstructReadLength = n3 + n4;
        this.minSampleReadLength = n + n2;
    }

    @Override
    public String getSampleBarcode(ReadInput readInput) {
        String string2 = readInput.getSampleBarcodeRead();
        this.assertReadIsLongEnough(string2, this.sampleBarcodeStartIndex, this.minSampleReadLength);
        return string2.substring(this.sampleBarcodeStartIndex, this.sampleBarcodeStartIndex + this.sampleBarcodeLength);
    }

    @Override
    public String getConstructBarcode(ReadInput readInput) {
        String string2 = readInput.getConstructBarcodeRead();
        this.assertReadIsLongEnough(string2, this.constructBarcodeStartIndex, this.minConstructReadLength);
        return string2.substring(this.constructBarcodeStartIndex, this.constructBarcodeStartIndex + this.constructBarcodeLength);
    }

    @Override
    public String truncateConstructBarcode(String string2) {
        if (string2.length() > this.constructBarcodeLength) {
            return string2.substring(0, this.constructBarcodeLength);
        }
        return string2;
    }

    void assertReadIsLongEnough(String string2, int n, int n2) {
        if (string2.length() < n2) {
            throw new ReadTooShortException(this.readTooShortMessage(string2, n, n2));
        }
    }

    private String readTooShortMessage(String string2, int n, int n2) {
        return "Read '" + string2 + "'\n" + " is too short to contain a barcode of length " + n2 + " starting at position " + n + ". To skip short reads, " + "re-run PoolQ with the --skip-short-reads flag.";
    }
}

