/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.broadinstitute.variant.utils.GeneralUtils;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;
import org.broadinstitute.variant.variantcontext.VariantJEXLContext;

class JEXLMap
implements Map<VariantContextUtils.JexlVCMatchExp, Boolean> {
    private final VariantContext vc;
    private final Genotype g;
    private JexlContext jContext = null;
    private Map<VariantContextUtils.JexlVCMatchExp, Boolean> jexl;

    public JEXLMap(Collection<VariantContextUtils.JexlVCMatchExp> collection, VariantContext variantContext, Genotype genotype) {
        this.vc = variantContext;
        this.g = genotype;
        this.initialize(collection);
    }

    public JEXLMap(Collection<VariantContextUtils.JexlVCMatchExp> collection, VariantContext variantContext) {
        this(collection, variantContext, null);
    }

    private void initialize(Collection<VariantContextUtils.JexlVCMatchExp> collection) {
        this.jexl = new HashMap<VariantContextUtils.JexlVCMatchExp, Boolean>();
        for (VariantContextUtils.JexlVCMatchExp jexlVCMatchExp : collection) {
            this.jexl.put(jexlVCMatchExp, null);
        }
    }

    private void createContext() {
        if (this.g == null) {
            this.jContext = new VariantJEXLContext(this.vc);
        } else {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (this.vc != null) {
                hashMap.put("CHROM", this.vc.getChr());
                hashMap.put("POS", this.vc.getStart());
                hashMap.put("TYPE", this.vc.getType().toString());
                hashMap.put("QUAL", String.valueOf(this.vc.getPhredScaledQual()));
                hashMap.put("ALLELES", GeneralUtils.join(";", this.vc.getAlleles()));
                hashMap.put("N_ALLELES", String.valueOf(this.vc.getNAlleles()));
                JEXLMap.addAttributesToMap(hashMap, this.vc.getAttributes());
                hashMap.put("FILTER", this.vc.isFiltered() ? "1" : "0");
                for (String object : this.vc.getFilters()) {
                    hashMap.put(String.valueOf(object), "1");
                }
                hashMap.put("GT", this.g.getGenotypeString());
                hashMap.put("isHomRef", this.g.isHomRef() ? "1" : "0");
                hashMap.put("isHet", this.g.isHet() ? "1" : "0");
                hashMap.put("isHomVar", this.g.isHomVar() ? "1" : "0");
                hashMap.put("GQ", this.g.getGQ());
                if (this.g.hasDP()) {
                    hashMap.put("DP", this.g.getDP());
                }
                for (Map.Entry entry : this.g.getExtendedAttributes().entrySet()) {
                    if (entry.getValue() == null || entry.getValue().equals(".")) continue;
                    hashMap.put((String)entry.getKey(), entry.getValue());
                }
            }
            this.jContext = new MapContext(hashMap);
        }
    }

    @Override
    public int size() {
        return this.jexl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jexl.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.jexl.containsKey(object);
    }

    @Override
    public Boolean get(Object object) {
        if (this.jexl.containsKey(object) && this.jexl.get(object) != null) {
            return this.jexl.get(object);
        }
        VariantContextUtils.JexlVCMatchExp jexlVCMatchExp = (VariantContextUtils.JexlVCMatchExp)object;
        this.evaluateExpression(jexlVCMatchExp);
        return this.jexl.get(jexlVCMatchExp);
    }

    @Override
    public Set<VariantContextUtils.JexlVCMatchExp> keySet() {
        return this.jexl.keySet();
    }

    @Override
    public Collection<Boolean> values() {
        for (VariantContextUtils.JexlVCMatchExp jexlVCMatchExp : this.jexl.keySet()) {
            if (this.jexl.get(jexlVCMatchExp) != null) continue;
            this.evaluateExpression(jexlVCMatchExp);
        }
        return this.jexl.values();
    }

    private void evaluateExpression(VariantContextUtils.JexlVCMatchExp jexlVCMatchExp) {
        if (this.jContext == null) {
            this.createContext();
        }
        try {
            Boolean bl = (Boolean)jexlVCMatchExp.exp.evaluate(this.jContext);
            this.jexl.put(jexlVCMatchExp, bl == null ? false : bl);
        }
        catch (Exception exception) {
            if (exception.getMessage().contains("undefined variable")) {
                this.jexl.put(jexlVCMatchExp, false);
            }
            throw new IllegalArgumentException(String.format("Invalid JEXL expression detected for %s with message %s", jexlVCMatchExp.name, exception.getMessage()));
        }
    }

    private static void addAttributesToMap(Map<String, Object> map2, Map<String, ?> map3) {
        for (Map.Entry<String, ?> entry : map3.entrySet()) {
            map2.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    @Override
    public Boolean put(VariantContextUtils.JexlVCMatchExp jexlVCMatchExp, Boolean bl) {
        return this.jexl.put(jexlVCMatchExp, bl);
    }

    @Override
    public void putAll(Map<? extends VariantContextUtils.JexlVCMatchExp, ? extends Boolean> map2) {
        this.jexl.putAll(map2);
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException("containsValue() not supported on a JEXLMap");
    }

    @Override
    public Boolean remove(Object object) {
        throw new UnsupportedOperationException("remove() not supported on a JEXLMap");
    }

    @Override
    public Set<Map.Entry<VariantContextUtils.JexlVCMatchExp, Boolean>> entrySet() {
        throw new UnsupportedOperationException("clear() not supported on a JEXLMap");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear() not supported on a JEXLMap");
    }
}

