/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.parser;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Iterator;
import journal.Error;
import journal.Error$;
import journal.Logger;
import journal.Logger$;
import kantan.codecs.collection.HasBuilder$;
import kantan.codecs.resource.Resource$;
import kantan.codecs.resource.ResourceIterator;
import kantan.codecs.strings.codecs$;
import kantan.csv.CsvConfiguration;
import kantan.csv.CsvConfiguration$Header$None$;
import kantan.csv.CsvConfiguration$QuotePolicy$WhenNeeded$;
import kantan.csv.CsvSource$;
import kantan.csv.HeaderDecoder$;
import kantan.csv.ReadError;
import kantan.csv.engine.ReaderEngine$;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.broadinstitute.gpp.poolq3.parser.InvalidFileException$;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData;
import org.broadinstitute.gpp.poolq3.parser.ReferenceEntry;
import org.broadinstitute.gpp.poolq3.seq.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$Int$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class ReferenceData$ {
    public static ReferenceData$ MODULE$;
    private final Logger log;
    private final Regex LineRegex;
    private final Regex DelimiterRegex;
    private volatile byte bitmap$init$0;

    static {
        new ReferenceData$();
    }

    public char guessDelimiter(BufferedReader br) {
        int n;
        br.mark(1024);
        Iterator iter = br.lines().iterator();
        if (iter.hasNext()) {
            int n2;
            String string = (String)iter.next();
            Option<List<String>> option = this.DelimiterRegex.unapplySeq(string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String d = (String)((LinearSeqOptimized)option.get()).apply(0);
                n2 = BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(d)).head());
            } else {
                n2 = 44;
            }
            n = n2;
        } else {
            n = 44;
        }
        int ret = n;
        br.reset();
        return (char)ret;
    }

    public void skipHeader(BufferedReader br) {
        String line;
        br.mark(1024);
        String string = line = br.readLine();
        Option<List<String>> option = this.LineRegex.unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            br.reset();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ReferenceData apply(Path file, char quote) {
        return (ReferenceData)resource.package$.MODULE$.managed((Function0<FileInputStream> & Serializable & scala.Serializable)() -> new FileInputStream(file.toFile()), resource.Resource$.MODULE$.closeableResource(), ClassManifestFactory$.MODULE$.classType(FileInputStream.class)).acquireAndGet((Function1<FileInputStream, ReferenceData> & Serializable & scala.Serializable)fin -> {
            BOMInputStream in = new BOMInputStream((InputStream)fin, false, ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            char delimiter = MODULE$.guessDelimiter(br);
            CsvConfiguration config = new CsvConfiguration(delimiter, quote, CsvConfiguration$QuotePolicy$WhenNeeded$.MODULE$, CsvConfiguration$Header$None$.MODULE$);
            MODULE$.skipHeader(br);
            ResourceIterator<Either<ReadError, List>> reader = kantan.csv.ops.package$.MODULE$.toCsvInputOps(br, CsvSource$.MODULE$.fromResource(Resource$.MODULE$.readerReaderResource())).asCsvReader(config, HeaderDecoder$.MODULE$.defaultHeaderDecoder(kantan.csv.codecs$.MODULE$.hasBuilderRowDecoder(kantan.csv.codecs$.MODULE$.fromStringDecoder(codecs$.MODULE$.stringStringCodec()), HasBuilder$.MODULE$.listHasBuilder())), ReaderEngine$.MODULE$.internalCsvReaderEngine());
            List barcodes = reader.map((Function1<Either, Option> & Serializable & scala.Serializable)x0$1 -> {
                Either either = x0$1;
                if (either instanceof Right) {
                    Option option;
                    Right right = (Right)either;
                    List xs = (List)right.value();
                    List list = xs;
                    if (!(list instanceof $colon$colon)) throw InvalidFileException$.MODULE$.apply(file, new StringBuilder(57).append("Incorrect number of columns. At least 2 required, got: ").append(xs.length()).append(": ").append(xs).toString());
                    $colon$colon $colon$colon = ($colon$colon)list;
                    String barcodeRaw = (String)$colon$colon.head();
                    List list2 = $colon$colon.tl$access$1();
                    if (!(list2 instanceof $colon$colon)) throw InvalidFileException$.MODULE$.apply(file, new StringBuilder(57).append("Incorrect number of columns. At least 2 required, got: ").append(xs.length()).append(": ").append(xs).toString());
                    $colon$colon $colon$colon2 = ($colon$colon)list2;
                    String idRaw = (String)$colon$colon2.head();
                    String barcode = barcodeRaw.trim();
                    String id = idRaw.trim();
                    if (barcode.isEmpty() && id.isEmpty()) {
                        option = None$.MODULE$;
                    } else {
                        if (!package$.MODULE$.isReferenceBarcode(barcode)) throw InvalidFileException$.MODULE$.apply(file, new StringBuilder(27).append(barcode).append(" is not a valid DNA barcode").toString());
                        option = new Some<ReferenceEntry>(new ReferenceEntry(barcode, id));
                    }
                    None$ none$ = option;
                    return none$;
                }
                if (!(either instanceof Left)) throw new MatchError(either);
                Left left = (Left)either;
                ReadError value = (ReadError)left.value();
                throw InvalidFileException$.MODULE$.apply(file, new StringBuilder(21).append("Unable to parse data ").append(value.getMessage()).toString());
            }).toList();
            if (barcodes.isEmpty()) {
                throw InvalidFileException$.MODULE$.apply(file, "Empty reference file");
            }
            return new ReferenceData((Seq)barcodes.flatten((Function1<Option, Iterable> & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)));
        });
    }

    public char apply$default$2() {
        return '\"';
    }

    public void checkLengths(Seq<ReferenceEntry> mappings) {
        Map barcodesByLength = mappings.groupBy((Function1<ReferenceEntry, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.barcodeLength()));
        if (barcodesByLength.keySet().size() != 1) {
            Seq examples = barcodesByLength.toSeq().flatMap((Function1<Tuple2, Iterable> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int length = tuple2._1$mcI$sp();
                Seq barcodes = (Seq)tuple2._2();
                Iterable iterable = Option$.MODULE$.option2Iterable(barcodes.headOption().map((Function1<ReferenceEntry, Tuple2> & Serializable & scala.Serializable)bc -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(length)), bc)));
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
            Seq sortedExamples = ((TraversableLike)examples.sortBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger(ReferenceData$.$anonfun$checkLengths$4(x0$2)), Ordering$Int$.MODULE$)).map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int length = tuple2._1$mcI$sp();
                ReferenceEntry example = (ReferenceEntry)tuple2._2();
                String string = new StringBuilder(10).append(example.referenceBarcode()).append(" is ").append(length).append(" bases").toString();
                return string;
            }, Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = this.log.backend().isErrorEnabled() ? this.log.handler().apply(new Error(new StringBuilder(10).append("Examples: ").append(sortedExamples.mkString(", ")).toString(), Error$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
            throw new IllegalArgumentException("Input barcodes must all be of the same length");
        }
    }

    public Function1<String, String> truncator(int newLength) {
        return (Function1<String, String> & Serializable & scala.Serializable)s -> s.substring(0, newLength);
    }

    public static final /* synthetic */ int $anonfun$checkLengths$4(Tuple2 x0$2) {
        int length;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int n = length = tuple2._1$mcI$sp();
        return n;
    }

    private ReferenceData$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.apply(ManifestFactory$.MODULE$.singleType(this));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.LineRegex = new StringOps(Predef$.MODULE$.augmentString("^(?:(?:\"[ACGTacgt:;-]+ *\")|(?:[ACGTacgt:;-]+ *))([\\t,]).+$")).r();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.DelimiterRegex = new StringOps(Predef$.MODULE$.augmentString("^(?:[^,\\t]+)([\\t,]).+$")).r();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

