/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.process;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import journal.Error;
import journal.Info;
import journal.Info$;
import journal.Logger;
import journal.Logger$;
import journal.Warn;
import journal.Warn$;
import org.broadinstitute.gpp.poolq3.PoolQSummary;
import org.broadinstitute.gpp.poolq3.barcode.Barcodes;
import org.broadinstitute.gpp.poolq3.process.Consumer;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\n\u0014\u0005yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0019I\u0005\u0001)A\u0005\u0015\"1\u0001\u000b\u0001Q\u0001\nECaa\u0017\u0001!B\u0013afAB2\u0001A\u00035A\rC\u0003C\u0013\u0011\u00051\u000eC\u0003o\u0013\u0011\u0005s\u000eC\u0003o\u0001\u0011\u00051oB\u0004y'\u0005\u0005\t\u0012A=\u0007\u000fI\u0019\u0012\u0011!E\u0001u\")!I\u0004C\u0001w\"9APDI\u0001\n\u0003i\b\u0002CA\t\u001dE\u0005I\u0011A?\u0003\u0019A{w\u000e\\)Qe>\u001cWm]:\u000b\u0005Q)\u0012a\u00029s_\u000e,7o\u001d\u0006\u0003-]\ta\u0001]8pYF\u001c$B\u0001\r\u001a\u0003\r9\u0007\u000f\u001d\u0006\u00035m\taB\u0019:pC\u0012Lgn\u001d;jiV$XMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007g>,(oY3\u0011\u0007\u001dz#G\u0004\u0002)[9\u0011\u0011\u0006L\u0007\u0002U)\u00111&H\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!AL\u0011\u0002\u000fA\f7m[1hK&\u0011\u0001'\r\u0002\t\u0013R,'/\u0019;pe*\u0011a&\t\t\u0003gYj\u0011\u0001\u000e\u0006\u0003kU\tqAY1sG>$W-\u0003\u00028i\tA!)\u0019:d_\u0012,7/\u0001\u0005d_:\u001cX/\\3s!\tQ4(D\u0001\u0014\u0013\ta4C\u0001\u0005D_:\u001cX/\\3s\u0003%\tX/Z;f'&TX\r\u0005\u0002!\u007f%\u0011\u0001)\t\u0002\u0004\u0013:$\u0018a\u0004:fa>\u0014HO\u0012:fcV,gnY=\u0002\rqJg.\u001b;?)\u0015!UIR$I!\tQ\u0004\u0001C\u0003&\u000b\u0001\u0007a\u0005C\u00039\u000b\u0001\u0007\u0011\bC\u0004>\u000bA\u0005\t\u0019\u0001 \t\u000f\u0005+\u0001\u0013!a\u0001}\u0005\u0019An\\4\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bqA[8ve:\fG.\u0003\u0002P\u0019\n1Aj\\4hKJ\fQ!];fk\u0016\u00042AU-3\u001b\u0005\u0019&B\u0001+V\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003-^\u000bA!\u001e;jY*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.T\u0005I\t%O]1z\u00052|7m[5oOF+X-^3\u0002\t\u0011|g.\u001a\t\u0003AuK!AX\u0011\u0003\u000f\t{w\u000e\\3b]\"\u0012\u0001\u0002\u0019\t\u0003A\u0005L!AY\u0011\u0003\u0011Y|G.\u0019;jY\u0016\u0014abQ8ogVlWM\u001d+ie\u0016\fGm\u0005\u0002\nKB\u0011a-[\u0007\u0002O*\u0011\u0001nV\u0001\u0005Y\u0006tw-\u0003\u0002kO\n1A\u000b\u001b:fC\u0012$\u0012\u0001\u001c\t\u0003[&i\u0011\u0001A\u0001\u0004eVtG#\u00019\u0011\u0005\u0001\n\u0018B\u0001:\"\u0005\u0011)f.\u001b;\u0015\u0003Q\u0004\"!\u001e<\u000e\u0003UI!a^\u000b\u0003\u0019A{w\u000e\\)Tk6l\u0017M]=\u0002\u0019A{w\u000e\\)Qe>\u001cWm]:\u0011\u0005ir1C\u0001\b )\u0005I\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001\u007fU\tqtp\u000b\u0002\u0002\u0002A!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011!C;oG\",7m[3e\u0015\r\tY!I\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\b\u0003\u000b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public final class PoolQProcess {
    private final Iterator<Barcodes> source;
    public final Consumer org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer;
    public final int org$broadinstitute$gpp$poolq3$process$PoolQProcess$$reportFrequency;
    public final Logger org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log;
    public final ArrayBlockingQueue<Barcodes> org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue;
    public volatile boolean org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done;
    private volatile byte bitmap$init$0;

    public static int $lessinit$greater$default$4() {
        return PoolQProcess$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return PoolQProcess$.MODULE$.$lessinit$greater$default$3();
    }

    public PoolQSummary run() {
        ConsumerThread consumerThread = new ConsumerThread();
        consumerThread.setName("Consumer");
        BoxedUnit boxedUnit = this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.backend().isInfoEnabled() ? this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.handler().apply(new Info("Beginning task processing.", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.start();
        consumerThread.start();
        this.source.foreach((Function1<Barcodes, Object> & Serializable & scala.Serializable)x$1 -> {
            this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.put(x$1);
            return BoxedUnit.UNIT;
        });
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done = true;
        BoxedUnit boxedUnit2 = this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.backend().isInfoEnabled() ? this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.handler().apply(new Info("Shutting down.", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        consumerThread.join();
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.close();
        return new PoolQSummary(this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed(), this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.matchingReads(), this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.matchPercent());
    }

    public PoolQProcess(Iterator<Barcodes> source2, Consumer consumer, int queueSize, int reportFrequency) {
        this.source = source2;
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer = consumer;
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$reportFrequency = reportFrequency;
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log = Logger$.MODULE$.apply(ManifestFactory$.MODULE$.singleType(this));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue = new ArrayBlockingQueue(queueSize);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public final class ConsumerThread
    extends Thread {
        @Override
        public void run() {
            long t0 = System.currentTimeMillis();
            while (!PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done || !PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.isEmpty()) {
                int n;
                try {
                    Option$.MODULE$.apply(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.poll(100L, TimeUnit.MILLISECONDS)).foreach((Function1<Barcodes, Object> & Serializable & scala.Serializable)next -> {
                        PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.consume(next);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InterruptedException) {
                        boxedUnit = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.backend().isWarnEnabled() ? PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.handler().apply(new Warn(new StringBuilder(59).append("Interrupted. Done = ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$done).append(" Processed ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed()).append(" reads; queue has ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.size()).append(" remaining").toString(), Warn$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
                    }
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = option.get();
                        boxedUnit = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.backend().isErrorEnabled() ? PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.handler().apply(new Error(new StringBuilder(22).append("Error processing read ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed()).toString(), new Some<Throwable>(e))) : BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                if ((n = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed()) % PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$reportFrequency != 0) continue;
                this.logProgress$1(n, t0);
            }
            this.logProgress$1(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed(), t0);
        }

        private final void logProgress$1(int n, long t0$1) {
            block0: {
                float nd = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.readsProcessed();
                long dt = System.currentTimeMillis() - t0$1;
                float avg = nd / (float)dt;
                float pct = PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$consumer.matchPercent();
                if (!PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.backend().isInfoEnabled()) break block0;
                PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$log.handler().apply(new Info(new StringBuilder(66).append("Processed ").append(n).append(" reads in ").append(dt).append(" ms (").append(avg).append(" reads/ms). Match percent: ").append(pct).append("; queue size: ").append(PoolQProcess.this.org$broadinstitute$gpp$poolq3$process$PoolQProcess$$queue.size()).toString(), Info$.MODULE$.apply$default$2()));
            }
        }

        public ConsumerThread() {
            if (PoolQProcess.this == null) {
                throw null;
            }
        }
    }
}

