/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CramVersionPolicies;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerHeaderIO;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SliceIO;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.cram.structure.block.BlockContentType;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ContainerIO {
    private static final Log log = Log.getInstance(ContainerIO.class);

    private static Container readContainer(Version version, InputStream inputStream, long containerByteOffset) {
        Container container = ContainerIO.readContainerInternal(version.major, inputStream, containerByteOffset);
        if (container == null) {
            CramVersionPolicies.eofNotFound(version);
            return ContainerIO.readContainerInternal(version.major, new ByteArrayInputStream(CramIO.ZERO_B_EOF_MARKER), containerByteOffset);
        }
        if (container.isEOF()) {
            log.debug("EOF marker found, file/stream is complete.");
        }
        return container;
    }

    public static Container readContainer(Version version, SeekableStream seekableInputStream) {
        try {
            long containerByteOffset = seekableInputStream.position();
            return ContainerIO.readContainer(version, seekableInputStream, containerByteOffset);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static Container readContainer(Version version, CountingInputStream countingInputStream) {
        long containerByteOffset = countingInputStream.getCount();
        return ContainerIO.readContainer(version, countingInputStream, containerByteOffset);
    }

    private static Container readContainerInternal(int major, InputStream inputStream, long containerByteOffset) {
        Container container = ContainerHeaderIO.readContainerHeader(major, inputStream, containerByteOffset);
        if (container.isEOF()) {
            return container;
        }
        container.compressionHeader = CompressionHeader.read(major, inputStream);
        ArrayList<Slice> slices = new ArrayList<Slice>();
        for (int sliceCounter = 0; sliceCounter < container.landmarks.length; ++sliceCounter) {
            slices.add(SliceIO.read(major, inputStream));
        }
        container.setSlicesAndByteOffset(slices, containerByteOffset);
        container.distributeIndexingParametersToSlices();
        log.debug("READ CONTAINER: " + container.toString());
        return container;
    }

    public static int writeContainer(Version version, Container container, OutputStream outputStream) {
        if (container.blocks != null && container.blocks.length > 0) {
            boolean isFileHeaderContainer;
            Block firstBlock = container.blocks[0];
            boolean bl = isFileHeaderContainer = firstBlock.getContentType() == BlockContentType.FILE_HEADER;
            if (isFileHeaderContainer) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                firstBlock.write(version.major, byteArrayOutputStream);
                container.containerBlocksByteSize = byteArrayOutputStream.size();
                int containerHeaderByteSize = ContainerHeaderIO.writeContainerHeader(version.major, container, outputStream);
                try {
                    outputStream.write(byteArrayOutputStream.toByteArray(), 0, container.containerBlocksByteSize);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
                return containerHeaderByteSize + container.containerBlocksByteSize;
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        container.compressionHeader.write(version, byteArrayOutputStream);
        container.blockCount = 1;
        ArrayList<Integer> landmarks = new ArrayList<Integer>();
        for (Slice slice : container.getSlices()) {
            landmarks.add(byteArrayOutputStream.size());
            SliceIO.write(version.major, slice, byteArrayOutputStream);
            ++container.blockCount;
            ++container.blockCount;
            if (slice.embeddedRefBlock != null) {
                ++container.blockCount;
            }
            container.blockCount += slice.external.size();
        }
        container.landmarks = landmarks.stream().mapToInt(Integer::intValue).toArray();
        container.containerBlocksByteSize = byteArrayOutputStream.size();
        container.distributeIndexingParametersToSlices();
        int containerHeaderLength = ContainerHeaderIO.writeContainerHeader(version.major, container, outputStream);
        try {
            outputStream.write(byteArrayOutputStream.toByteArray(), 0, container.containerBlocksByteSize);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        log.debug("CONTAINER WRITTEN: " + container.toString());
        return containerHeaderLength + container.containerBlocksByteSize;
    }
}

