/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.structure.DataSeriesType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataSeries {
    BF_BitFlags(DataSeriesType.INT, "BF", 1),
    CF_CompressionBitFlags(DataSeriesType.INT, "CF", 2),
    RI_RefId(DataSeriesType.INT, "RI", 3),
    RL_ReadLength(DataSeriesType.INT, "RL", 4),
    AP_AlignmentPositionOffset(DataSeriesType.INT, "AP", 5),
    RG_ReadGroup(DataSeriesType.INT, "RG", 6),
    RN_ReadName(DataSeriesType.BYTE_ARRAY, "RN", 7),
    NF_RecordsToNextFragment(DataSeriesType.INT, "NF", 8),
    MF_MateBitFlags(DataSeriesType.INT, "MF", 9),
    NS_NextFragmentReferenceSequenceID(DataSeriesType.INT, "NS", 10),
    NP_NextFragmentAlignmentStart(DataSeriesType.INT, "NP", 11),
    TS_InsertSize(DataSeriesType.INT, "TS", 12),
    TL_TagIdList(DataSeriesType.INT, "TL", 13),
    TC_TagCount(DataSeriesType.INT, "TC", 14),
    TN_TagNameAndType(DataSeriesType.INT, "TN", 15),
    MQ_MappingQualityScore(DataSeriesType.INT, "MQ", 16),
    FN_NumberOfReadFeatures(DataSeriesType.INT, "FN", 17),
    FP_FeaturePosition(DataSeriesType.INT, "FP", 18),
    FC_FeatureCode(DataSeriesType.BYTE, "FC", 19),
    BB_bases(DataSeriesType.BYTE_ARRAY, "BB", 20),
    QQ_scores(DataSeriesType.BYTE_ARRAY, "QQ", 21),
    BA_Base(DataSeriesType.BYTE, "BA", 22),
    QS_QualityScore(DataSeriesType.BYTE, "QS", 23),
    BS_BaseSubstitutionCode(DataSeriesType.BYTE, "BS", 24),
    IN_Insertion(DataSeriesType.BYTE_ARRAY, "IN", 25),
    DL_DeletionLength(DataSeriesType.INT, "DL", 26),
    RS_RefSkip(DataSeriesType.INT, "RS", 27),
    SC_SoftClip(DataSeriesType.BYTE_ARRAY, "SC", 28),
    PD_padding(DataSeriesType.INT, "PD", 29),
    HC_HardClip(DataSeriesType.INT, "HC", 30),
    TM_TestMark(DataSeriesType.INT, "TM", 31),
    TV_TestMark(DataSeriesType.INT, "TV", 32);

    private final DataSeriesType type;
    private final String canonicalName;
    private final Integer externalBlockContentId;
    private static final Map<String, DataSeries> CANONICAL_NAME_MAP;

    private DataSeries(DataSeriesType type, String name, Integer contentId) {
        this.type = type;
        this.canonicalName = name;
        this.externalBlockContentId = contentId;
    }

    public DataSeriesType getType() {
        return this.type;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public Integer getExternalBlockContentId() {
        return this.externalBlockContentId;
    }

    public static DataSeries byCanonicalName(String dataSeriesAbbreviation) {
        if (dataSeriesAbbreviation.length() != 2) {
            throw new CRAMException("Data Series Canonical Name should be exactly two characters: " + dataSeriesAbbreviation);
        }
        return Optional.ofNullable(CANONICAL_NAME_MAP.get(dataSeriesAbbreviation)).orElseThrow(() -> new CRAMException("Could not find Data Series Encoding for: " + dataSeriesAbbreviation));
    }

    static {
        CANONICAL_NAME_MAP = Collections.unmodifiableMap(Stream.of(DataSeries.values()).collect(Collectors.toMap(DataSeries::getCanonicalName, Function.identity())));
    }
}

