/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.barcode;

import java.io.Serializable;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask0;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask1;
import org.broadinstitute.gpp.poolq3.barcode.KeyMask2;
import org.broadinstitute.gpp.poolq3.barcode.KeyMaskN;
import org.broadinstitute.gpp.poolq3.barcode.KeyRange;
import org.broadinstitute.gpp.poolq3.barcode.KeyRange$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcC$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class KeyMask$ {
    public static KeyMask$ MODULE$;

    static {
        new KeyMask$();
    }

    public KeyMask apply(String pattern) {
        return this.create(pattern, this.parsePatternRanges(pattern));
    }

    public KeyMask apply(int contextLength, Seq<KeyRange> keyRanges) {
        Predef$.MODULE$.require(keyRanges.nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Key mask must have at least one key range");
        keyRanges.foreach((Function1<KeyRange, Object> & Serializable & scala.Serializable)r -> {
            Predef$.MODULE$.require(r.end0() < contextLength, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(59).append("contextLength (").append(contextLength$1).append(") is not large enough to contain key range: ").append(r).toString());
            return BoxedUnit.UNIT;
        });
        Seq<KeyRange> mergedRanges = this.mergeAdjacent((Seq)keyRanges.sorted(KeyRange$.MODULE$.ord()));
        String pat = this.constructPattern(contextLength, keyRanges);
        return this.create(pat, mergedRanges);
    }

    private KeyMask create(String pattern, Seq<KeyRange> mergedRanges) {
        KeyMask keyMask;
        int n = mergedRanges.length();
        switch (n) {
            case 1: {
                KeyRange r = (KeyRange)mergedRanges.head();
                if (r.start0() == 0 && r.length() == pattern.length()) {
                    keyMask = new KeyMask0(pattern);
                    break;
                }
                keyMask = new KeyMask1(pattern, r);
                break;
            }
            case 2: {
                keyMask = new KeyMask2(pattern, (KeyRange)mergedRanges.apply(false), (KeyRange)mergedRanges.apply(true));
                break;
            }
            default: {
                keyMask = new KeyMaskN(pattern, mergedRanges);
                break;
            }
        }
        return keyMask;
    }

    public KeyMask fromString(int contextLength, String str) {
        KeyRange[] ranges = (KeyRange[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])str.split(",", -1))).map((Function1<String, KeyRange> & Serializable & scala.Serializable)s -> KeyRange$.MODULE$.apply(s.trim()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KeyRange.class)));
        Predef$.MODULE$.require(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])ranges)).nonEmpty(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(47).append("KeyMask range string yields no valid ranges: '").append(str).append("'").toString());
        return this.apply(contextLength, Predef$.MODULE$.wrapRefArray((Object[])ranges));
    }

    public Seq<KeyRange> mergeAdjacent(Seq<KeyRange> bases) {
        return (Seq)((TraversableOnce)bases.foldLeft(Nil$.MODULE$, (Function2<List, KeyRange, List> & Serializable & scala.Serializable)(acc, current) -> KeyMask$.merge$1(acc, current))).toIndexedSeq().reverse();
    }

    public List<KeyRange> parsePatternRanges(String pattern) {
        return this.loop$1(Nil$.MODULE$, ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(pattern)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).toList());
    }

    public String constructPattern(int length, Seq<KeyRange> ranges) {
        char[] chars = (char[])Array$.MODULE$.fill(length, (JFunction0$mcC$sp & scala.Serializable)() -> 'n', ClassTag$.MODULE$.Char());
        ranges.foreach((Function1<KeyRange, Object> & Serializable & scala.Serializable)range -> {
            KeyMask$.$anonfun$constructPattern$2(chars, range);
            return BoxedUnit.UNIT;
        });
        return new String(chars);
    }

    private static final List merge$1(List acc, KeyRange current) {
        List<KeyRange> list;
        List list2 = acc;
        if (((Object)Nil$.MODULE$).equals(list2)) {
            KeyRange keyRange = current;
            list = Nil$.MODULE$.$colon$colon(keyRange);
        } else if (list2 instanceof $colon$colon) {
            List<KeyRange> list3;
            $colon$colon $colon$colon = ($colon$colon)list2;
            KeyRange head = (KeyRange)$colon$colon.head();
            List<KeyRange> tail = $colon$colon.tl$access$1();
            if (head.end0() >= current.start0() - 1) {
                KeyRange keyRange = new KeyRange(head.start0(), current.end0());
                list3 = tail.$colon$colon(keyRange);
            } else {
                KeyRange keyRange = current;
                list3 = acc.$colon$colon(keyRange);
            }
            list = list3;
        } else {
            throw new MatchError(list2);
        }
        return list;
    }

    public static final /* synthetic */ boolean $anonfun$parsePatternRanges$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        char p = tuple2._1$mcC$sp();
        boolean bl = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(p));
        return bl;
    }

    private final List loop$1(List acc, List ps) {
        block5: {
            List list;
            while (true) {
                boolean bl = false;
                $colon$colon $colon$colon = null;
                list = ps;
                if (((Object)Nil$.MODULE$).equals(list)) break block5;
                if (list instanceof $colon$colon) {
                    bl = true;
                    $colon$colon = ($colon$colon)list;
                    Tuple2 tuple2 = (Tuple2)$colon$colon.head();
                    if (tuple2 != null) {
                        char base = tuple2._1$mcC$sp();
                        int startIdx = tuple2._2$mcI$sp();
                        if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(base))) {
                            Tuple2 tuple22 = ps.span((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(KeyMask$.$anonfun$parsePatternRanges$1(x0$1)));
                            if (tuple22 == null) {
                                throw new MatchError(tuple22);
                            }
                            List span = tuple22._1();
                            List rest = tuple22._2();
                            Tuple2 tuple23 = new Tuple2(span, rest);
                            Tuple2 tuple24 = tuple23;
                            List span2 = tuple24._1();
                            List rest2 = tuple24._2();
                            KeyRange keyRange = new KeyRange(startIdx, startIdx + span2.length() - 1);
                            ps = rest2;
                            acc = acc.$colon$colon(keyRange);
                            continue;
                        }
                    }
                }
                if (!bl) break;
                Tuple2 tuple2 = (Tuple2)$colon$colon.head();
                List tl = $colon$colon.tl$access$1();
                if (tuple2 == null) break;
                ps = tl;
            }
            throw new MatchError(list);
        }
        Object object = acc.reverse();
        return object;
    }

    public static final /* synthetic */ void $anonfun$constructPattern$2(char[] chars$1, KeyRange range) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(range.start0()), range.end0()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            chars$1[i] = RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(chars$1[i]));
        });
    }

    private KeyMask$() {
        MODULE$ = this;
    }
}

