/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteringSamIterator
implements CloseableIterator<SAMRecord> {
    private final PeekableIterator<SAMRecord> iterator;
    private final SamRecordFilter filter;
    private boolean filterReadPairs = false;
    private SAMRecord next = null;

    public FilteringSamIterator(Iterator<SAMRecord> iterator, SamRecordFilter filter2, boolean filterByPair) {
        if (filterByPair && iterator instanceof SAMRecordIterator) {
            ((SAMRecordIterator)iterator).assertSorted(SAMFileHeader.SortOrder.queryname);
        }
        this.iterator = new PeekableIterator<SAMRecord>(iterator);
        this.filter = filter2;
        this.filterReadPairs = filterByPair;
        this.next = this.getNextRecord();
    }

    public FilteringSamIterator(Iterator<SAMRecord> iterator, SamRecordFilter filter2) {
        this.iterator = new PeekableIterator<SAMRecord>(iterator);
        this.filter = filter2;
        this.next = this.getNextRecord();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public SAMRecord next() {
        if (this.next == null) {
            throw new NoSuchElementException("Iterator has no more elements.");
        }
        SAMRecord result = this.next;
        this.next = this.getNextRecord();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove() not supported by FilteringSamIterator");
    }

    @Override
    public void close() {
        CloserUtil.close(this.iterator);
    }

    private SAMRecord getNextRecord() {
        while (this.iterator.hasNext()) {
            SAMRecord record = this.iterator.next();
            if (this.filterReadPairs && record.getReadPairedFlag() && record.getFirstOfPairFlag() && this.iterator.hasNext()) {
                SamPairUtil.assertMate(record, this.iterator.peek());
                if (this.filter.filterOut(record, this.iterator.peek())) {
                    this.iterator.next();
                    continue;
                }
                return record;
            }
            if (this.filterReadPairs && record.getReadPairedFlag() && record.getSecondOfPairFlag()) {
                return record;
            }
            if (this.filter.filterOut(record)) continue;
            return record;
        }
        return null;
    }
}

