/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3.reports;

import better.files.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import journal.Logger;
import journal.Logger$;
import journal.Warn;
import journal.Warn$;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.broadinstitute.gpp.poolq3.files.package$;
import org.broadinstitute.gpp.poolq3.files.package$PathToScalaFile$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import scala.Array$;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class CorrelationFileWriter$ {
    public static CorrelationFileWriter$ MODULE$;
    private final Logger log;
    private volatile boolean bitmap$init$0;

    static {
        new CorrelationFileWriter$();
    }

    public void write(Path file, Map<String, Map<String, Object>> scores, Reference rowReference, Reference colReference) {
        if (rowReference.allBarcodes().size() < 2) {
            if (this.log.backend().isWarnEnabled()) {
                this.log.handler().apply(new Warn("Cannot compute correlation for 1-length vector, skipping...", Warn$.MODULE$.apply$default$2()));
            }
        } else {
            boolean x$1;
            PearsonsCorrelation cor = new PearsonsCorrelation();
            double[][] scoreMatrix = this.getNormalizedScoresMatrix(scores, rowReference, colReference);
            RealMatrix pearsonMatrix = cor.computeCorrelationMatrix(scoreMatrix);
            File qual$1 = package$PathToScalaFile$.MODULE$.toScalaFile$extension(package$.MODULE$.PathToScalaFile(file));
            boolean x$2 = x$1 = qual$1.printWriter$default$1();
            Seq<OpenOption> x$3 = qual$1.printWriter$default$2(x$2);
            qual$1.printWriter(x$2, x$3).foreach((Function1<PrintWriter, Object> & Serializable & scala.Serializable)pw -> {
                CorrelationFileWriter$.$anonfun$write$1(colReference, pearsonMatrix, pw);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void printHeaders(Reference colReference, PrintWriter pw) {
        pw.println(new StringBuilder(1).append("\t").append(colReference.allIds().mkString("\t")).toString());
    }

    private double[][] getNormalizedScoresMatrix(Map<String, Map<String, Object>> scores, Reference rowReference, Reference colReference) {
        double[][] matrix = (double[][])Array$.MODULE$.ofDim(rowReference.allBarcodes().size(), colReference.allIds().size(), ClassTag$.MODULE$.Double());
        rowReference.allBarcodes().indices().foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            String row = (String)rowReference.allBarcodes().apply(i);
            Map rowScores = (Map)scores.apply(row);
            colReference.allIds().indices().foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)j -> {
                matrix$1[i$2][j] = BoxesRunTime.unboxToDouble(rowScores.apply(colReference.allIds().apply(j)));
            });
        });
        return matrix;
    }

    public static final /* synthetic */ void $anonfun$write$1(Reference colReference$1, RealMatrix pearsonMatrix$1, PrintWriter pw) {
        MODULE$.printHeaders(colReference$1, pw);
        colReference$1.allIds().indices().foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            pw.print((String)colReference$1.allIds().apply(i));
            colReference$1.allIds().indices().foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)j -> pw.print(new StringBuilder(1).append("\t").append(org.broadinstitute.gpp.poolq3.numeric.package$.MODULE$.Decimal00Format().format(pearsonMatrix$1.getEntry(i, j))).toString()));
            pw.println();
        });
    }

    private CorrelationFileWriter$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.apply(ManifestFactory$.MODULE$.singleType(this));
        this.bitmap$init$0 = true;
    }
}

