/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gpp.poolq3;

import better.files.File;
import better.files.File$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import journal.Info;
import journal.Info$;
import journal.Logger;
import journal.Logger$;
import org.broadinstitute.gpp.poolq3.PoolQConfig;
import org.broadinstitute.gpp.poolq3.PoolQConfig$;
import org.broadinstitute.gpp.poolq3.PoolQSummary;
import org.broadinstitute.gpp.poolq3.barcode.BarcodePolicy;
import org.broadinstitute.gpp.poolq3.barcode.BarcodePolicy$;
import org.broadinstitute.gpp.poolq3.barcode.Barcodes;
import org.broadinstitute.gpp.poolq3.barcode.package$;
import org.broadinstitute.gpp.poolq3.hist.Histogram;
import org.broadinstitute.gpp.poolq3.hist.OpenHashMapHistogram;
import org.broadinstitute.gpp.poolq3.hist.TupleHistogram;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterable;
import org.broadinstitute.gpp.poolq3.parser.CloseableIterator;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData;
import org.broadinstitute.gpp.poolq3.parser.ReferenceData$;
import org.broadinstitute.gpp.poolq3.process.Consumer;
import org.broadinstitute.gpp.poolq3.process.NoOpConsumer;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess;
import org.broadinstitute.gpp.poolq3.process.PoolQProcess$;
import org.broadinstitute.gpp.poolq3.process.ScoringConsumer;
import org.broadinstitute.gpp.poolq3.process.State;
import org.broadinstitute.gpp.poolq3.process.State$;
import org.broadinstitute.gpp.poolq3.reference.ExactReference;
import org.broadinstitute.gpp.poolq3.reference.ExactReference$;
import org.broadinstitute.gpp.poolq3.reference.Reference;
import org.broadinstitute.gpp.poolq3.reports.BarcodeScoresWriter$;
import org.broadinstitute.gpp.poolq3.reports.CorrelationFileWriter$;
import org.broadinstitute.gpp.poolq3.reports.LogNormalizedScoresWriter$;
import org.broadinstitute.gpp.poolq3.reports.QualityWriter$;
import org.broadinstitute.gpp.poolq3.reports.ScoresWriter$;
import org.broadinstitute.gpp.poolq3.reports.UnexpectedSequenceWriter$;
import resource.Resource$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.ManifestFactory$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class PoolQ$ {
    public static PoolQ$ MODULE$;
    private final Logger log;
    private volatile boolean bitmap$init$0;

    static {
        new PoolQ$();
    }

    public final void main(String[] args) {
        Option<PoolQConfig> option = PoolQConfig$.MODULE$.parse(args);
        if (None$.MODULE$.equals(option)) {
            System.exit(-1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            PoolQConfig config = (PoolQConfig)some.value();
            try {
                PoolQSummary _ = this.run(config);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Throwable t = option2.get();
                this.log.backend().error("PoolQ failed", t);
                System.exit(-1);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
    }

    public final PoolQSummary run(PoolQConfig config) {
        BoxedUnit boxedUnit;
        Option option;
        BoxedUnit boxedUnit2 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info(PoolQConfig$.MODULE$.summarize(config), Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        BoxedUnit boxedUnit3 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info("Reading row reference data", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        ReferenceData rowReferenceData = ReferenceData$.MODULE$.apply(config.rowReference(), ReferenceData$.MODULE$.apply$default$2());
        BoxedUnit boxedUnit4 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info("Reading column reference data", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        ReferenceData colReferenceData = ReferenceData$.MODULE$.apply(config.colReference(), ReferenceData$.MODULE$.apply$default$2());
        BoxedUnit boxedUnit5 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info("Reading global reference data", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        Option globalReferenceDataOpt = config.globalReference().map((Function1<Path, ReferenceData> & Serializable & scala.Serializable)x$1 -> ReferenceData$.MODULE$.apply((Path)x$1, ReferenceData$.MODULE$.apply$default$2()));
        BarcodePolicy rowBarcodePolicy = BarcodePolicy$.MODULE$.apply(config.rowBarcodePolicyStr(), rowReferenceData.barcodeLength(), config.skipShortReads());
        BarcodePolicy colBarcodePolicy = BarcodePolicy$.MODULE$.apply(config.colBarcodePolicyStr(), colReferenceData.barcodeLength(), config.skipShortReads());
        BoxedUnit boxedUnit6 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info("Building row reference", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        Reference rowReference = org.broadinstitute.gpp.poolq3.reference.package$.MODULE$.referenceFor(config.rowMatchFn(), ReferenceData$.MODULE$.truncator(rowBarcodePolicy.length()), config.countAmbiguous(), rowReferenceData.mappings());
        BoxedUnit boxedUnit7 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info("Building column reference", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        Reference colReference = org.broadinstitute.gpp.poolq3.reference.package$.MODULE$.referenceFor(config.colMatchFn(), ReferenceData$.MODULE$.truncator(colBarcodePolicy.length()), config.countAmbiguous(), colReferenceData.mappings());
        Option globalReference = globalReferenceDataOpt.map((Function1<ReferenceData, ExactReference> & Serializable & scala.Serializable)referenceData -> {
            BoxedUnit boxedUnit = PoolQ$.MODULE$.log.backend().isInfoEnabled() ? PoolQ$.MODULE$.log.handler().apply(new Info("Building global reference", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
            return ExactReference$.MODULE$.apply(referenceData.mappings(), (Function1<String, String> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x), false);
        });
        CloseableIterable<Barcodes> barcodes = package$.MODULE$.barcodeSource(config, rowBarcodePolicy, colBarcodePolicy);
        if (config.skipUnexpectedSequenceReport()) {
            option = None$.MODULE$;
        } else {
            Option ret = config.unexpectedSequenceCacheDir().map((Function1<Path, Path> & Serializable & scala.Serializable)x$2 -> Files.createDirectories(x$2, new FileAttribute[0])).orElse((Function0<Some> & Serializable & scala.Serializable)() -> {
                String x$1 = "unexpected-sequence-cache";
                Option<File> x$2 = File$.MODULE$.newTemporaryDirectory$default$2();
                Seq<FileAttribute<?>> x$3 = File$.MODULE$.newTemporaryDirectory$default$3(x$1, x$2);
                Path ret = File$.MODULE$.newTemporaryDirectory(x$1, x$2, x$3).path();
                return new Some<Path>(ret);
            });
            ret.foreach((Function1<Path, Object> & Serializable & scala.Serializable)path -> {
                PoolQ$.$anonfun$run$6(path);
                return BoxedUnit.UNIT;
            });
            option = ret;
        }
        None$ unexpectedSequenceCacheDir = option;
        State state = new State(new TupleHistogram<String>(), new OpenHashMapHistogram<String>(), new OpenHashMapHistogram<String>(), State$.MODULE$.$lessinit$greater$default$4(), State$.MODULE$.$lessinit$greater$default$5(), State$.MODULE$.$lessinit$greater$default$6(), State$.MODULE$.$lessinit$greater$default$7(), State$.MODULE$.$lessinit$greater$default$8(), State$.MODULE$.$lessinit$greater$default$9(), State$.MODULE$.$lessinit$greater$default$10(), State$.MODULE$.$lessinit$greater$default$11());
        Consumer consumer = config.noopConsumer() ? new NoOpConsumer() : new ScoringConsumer(rowReference, colReference, config.countAmbiguous(), unexpectedSequenceCacheDir, state);
        PoolQSummary ret = this.runProcess(barcodes, consumer);
        Histogram<Tuple2<String, String>> scores = state.known();
        BoxedUnit boxedUnit8 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info(new StringBuilder(20).append("Writing scores file ").append(config.scoresFile()).toString(), Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        ScoresWriter$.MODULE$.write(config.scoresFile(), scores, rowReference, colReference, config.scoresDialect());
        BoxedUnit boxedUnit9 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info(new StringBuilder(21).append("Writing quality file ").append(config.qualityFile()).toString(), Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        QualityWriter$.MODULE$.write(config.qualityFile(), state, rowReference, colReference);
        BoxedUnit boxedUnit10 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info(new StringBuilder(35).append("Writing log-normalized scores file ").append(config.normalizedScoresFile()).toString(), Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        Map<String, Map<String, Object>> logScores = LogNormalizedScoresWriter$.MODULE$.logNormalizedScores(scores, rowReference, colReference);
        LogNormalizedScoresWriter$.MODULE$.write(config.normalizedScoresFile(), logScores, rowReference, colReference, config.scoresDialect());
        BoxedUnit boxedUnit11 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info(new StringBuilder(28).append("Writing barcode scores file ").append(config.barcodeScoresFile()).toString(), Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        BarcodeScoresWriter$.MODULE$.write(config.barcodeScoresFile(), scores, rowReference, colReference, config.scoresDialect());
        BoxedUnit boxedUnit12 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info(new StringBuilder(25).append("Writing correlation file ").append(config.correlationFile()).toString(), Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        if (colReference.allIds().lengthCompare(1) > 0) {
            CorrelationFileWriter$.MODULE$.write(config.correlationFile(), logScores, rowReference, colReference);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info("Skipping correlation file for single experimental condition", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        }
        unexpectedSequenceCacheDir.foreach((Function1<Path, Object> & Serializable & scala.Serializable)dir -> {
            PoolQ$.$anonfun$run$7(config, colReference, globalReference, dir);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit13 = this.log.backend().isInfoEnabled() ? this.log.handler().apply(new Info("PoolQ complete", Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        return ret;
    }

    public PoolQSummary runProcess(CloseableIterable<Barcodes> barcodes, Consumer consumer) {
        return (PoolQSummary)resource.package$.MODULE$.managed((Function0<CloseableIterator> & Serializable & scala.Serializable)() -> barcodes.iterator(), Resource$.MODULE$.closeableResource(), ClassManifestFactory$.MODULE$.classType(CloseableIterator.class, ClassManifestFactory$.MODULE$.classType(Barcodes.class), Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0]))).acquireAndGet((Function1<CloseableIterator, PoolQSummary> & Serializable & scala.Serializable)iterator -> {
            PoolQProcess process = new PoolQProcess((Iterator<Barcodes>)iterator, consumer, PoolQProcess$.MODULE$.$lessinit$greater$default$3(), PoolQProcess$.MODULE$.$lessinit$greater$default$4());
            return process.run();
        });
    }

    public static final /* synthetic */ void $anonfun$run$6(Path path) {
        block0: {
            if (!PoolQ$.MODULE$.log.backend().isInfoEnabled()) break block0;
            PoolQ$.MODULE$.log.handler().apply(new Info(new StringBuilder(39).append("Writing unexpected sequence reports to ").append(path).toString(), Info$.MODULE$.apply$default$2()));
        }
    }

    public static final /* synthetic */ void $anonfun$run$7(PoolQConfig config$1, Reference colReference$1, Option globalReference$1, Path dir) {
        BoxedUnit boxedUnit = PoolQ$.MODULE$.log.backend().isInfoEnabled() ? PoolQ$.MODULE$.log.handler().apply(new Info(new StringBuilder(35).append("Writing unexpected sequence report ").append(config$1.unexpectedSequencesFile()).toString(), Info$.MODULE$.apply$default$2())) : BoxedUnit.UNIT;
        UnexpectedSequenceWriter$.MODULE$.write(config$1.unexpectedSequencesFile(), dir, config$1.unexpectedSequencesToReport(), colReference$1, globalReference$1);
    }

    private PoolQ$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.apply(ManifestFactory$.MODULE$.singleType(this));
        this.bitmap$init$0 = true;
    }
}

