/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.variants.vcf.vcfv3_3;

import htsjdk.beta.codecs.variants.vcf.VCFCodec;
import htsjdk.beta.codecs.variants.vcf.VCFDecoder;
import htsjdk.beta.codecs.variants.vcf.VCFEncoder;
import htsjdk.beta.codecs.variants.vcf.vcfv3_3.VCFDecoderV3_3;
import htsjdk.beta.codecs.variants.vcf.vcfv3_3.VCFEncoderV3_3;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.variants.VariantsDecoderOptions;
import htsjdk.beta.plugin.variants.VariantsEncoderOptions;
import htsjdk.utils.ValidationUtils;

public class VCFCodecV3_3
extends VCFCodec {
    public static final HtsVersion VCF_V33_VERSION = new HtsVersion(3, 3, 0);
    private static final String VCF_V33_MAGIC = "##fileformat=VCFv3.3";

    @Override
    public HtsVersion getVersion() {
        return VCF_V33_VERSION;
    }

    public VCFDecoder getDecoder(Bundle inputBundle, VariantsDecoderOptions decoderOptions) {
        ValidationUtils.nonNull(inputBundle, "inputBundle");
        ValidationUtils.nonNull(decoderOptions, "decoderOptions");
        return new VCFDecoderV3_3(inputBundle, decoderOptions);
    }

    public VCFEncoder getEncoder(Bundle outputBundle, VariantsEncoderOptions encoderOptions) {
        ValidationUtils.nonNull(outputBundle, "outputBundle");
        ValidationUtils.nonNull(encoderOptions, "encoderOptions");
        return new VCFEncoderV3_3(outputBundle, encoderOptions);
    }

    @Override
    public boolean runVersionUpgrade(HtsVersion sourceCodecVersion, HtsVersion targetCodecVersion) {
        throw new HtsjdkUnsupportedOperationException("Version upgrade not yet implemented");
    }

    @Override
    protected String getSignatureString() {
        return VCF_V33_MAGIC;
    }
}

