/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.io;

import htsjdk.samtools.util.FileExtensions;
import htsjdk.utils.ValidationUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Optional;

public interface IOPath {
    public URI getURI();

    public String getURIString();

    public String getRawInputString();

    public boolean hasFileSystemProvider();

    public boolean isPath();

    public Path toPath();

    public String getToPathFailureReason();

    default public String getScheme() {
        return this.getURI().getScheme();
    }

    default public Optional<String> getExtension() {
        int indexOfLastDot;
        String lastComponent;
        int indexOfLastComponent;
        String hierarchicalPath = this.getURI().getPath();
        if (hierarchicalPath != null && (indexOfLastComponent = hierarchicalPath.lastIndexOf(FileSystems.getDefault().getSeparator())) != -1 && indexOfLastComponent < hierarchicalPath.length() - 1 && (lastComponent = hierarchicalPath.substring(indexOfLastComponent + 1)).length() > 0 && (indexOfLastDot = lastComponent.lastIndexOf(46)) != -1 && indexOfLastDot < lastComponent.length() - 1) {
            return Optional.of(lastComponent.substring(indexOfLastDot));
        }
        return Optional.empty();
    }

    default public boolean hasExtension(String extension2) {
        ValidationUtils.nonNull(extension2, "Target extension must not be null");
        ValidationUtils.validateArg(extension2.length() > 1, "Target extension must be length > 1");
        ValidationUtils.validateArg(extension2.charAt(0) == '.', "Target extension must include the leading '.'");
        String hierarchicalPath = this.getURI().getPath();
        return hierarchicalPath == null ? false : hierarchicalPath.toLowerCase().endsWith(extension2.toLowerCase());
    }

    default public Optional<String> getBaseName() {
        String lastComponent;
        String hierarchicalPath = this.getURI().getPath();
        int indexOfLastComponent = hierarchicalPath.lastIndexOf(FileSystems.getDefault().getSeparator());
        if (indexOfLastComponent != -1 && indexOfLastComponent < hierarchicalPath.length() - 1 && (lastComponent = hierarchicalPath.substring(indexOfLastComponent + 1)).length() > 0) {
            int indexOfLastDot = lastComponent.lastIndexOf(46);
            if (indexOfLastDot == -1) {
                return Optional.of(lastComponent);
            }
            if (indexOfLastDot > 1) {
                return Optional.of(lastComponent.substring(0, indexOfLastDot));
            }
        }
        return Optional.empty();
    }

    default public boolean isSam() {
        return this.hasExtension(".sam");
    }

    default public boolean isBam() {
        return this.hasExtension(".bam");
    }

    default public boolean isCram() {
        return this.hasExtension(".cram");
    }

    default public boolean isFasta() {
        return FileExtensions.FASTA.stream().anyMatch(this::hasExtension);
    }

    public InputStream getInputStream();

    public OutputStream getOutputStream();
}

